/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.entity;

import com.mrbysco.spelled.registry.SpelledRegistry;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractSpellEntity
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<CompoundTag> SPELL_ORDER = SynchedEntityData.defineId(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<Integer> SPELL_TYPE = SynchedEntityData.defineId(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<OptionalInt> COLOR = SynchedEntityData.defineId(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    private static final EntityDataAccessor<Boolean> FIERY = SynchedEntityData.defineId(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LAVA = SynchedEntityData.defineId(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> WATER = SynchedEntityData.defineId(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> COLD = SynchedEntityData.defineId(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SNOW = SynchedEntityData.defineId(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SMOKY = SynchedEntityData.defineId(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> INKY = SynchedEntityData.defineId(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SILKY = SynchedEntityData.defineId(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> SIZE_MULTIPLIER = SynchedEntityData.defineId(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> POWER = SynchedEntityData.defineId(AbstractSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public AbstractSpellEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public AbstractSpellEntity(EntityType<? extends AbstractHurtingProjectile> entityType, LivingEntity shooter, Level level) {
        super(SpelledRegistry.SPELL.get(), level);
        this.setPos(shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ());
        this.setOwner((Entity)shooter);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPELL_ORDER, (Object)new CompoundTag());
        builder.define(SPELL_TYPE, (Object)0);
        builder.define(COLOR, (Object)OptionalInt.empty());
        builder.define(FIERY, (Object)false);
        builder.define(LAVA, (Object)false);
        builder.define(WATER, (Object)false);
        builder.define(COLD, (Object)false);
        builder.define(SNOW, (Object)false);
        builder.define(SMOKY, (Object)false);
        builder.define(INKY, (Object)false);
        builder.define(SILKY, (Object)false);
        builder.define(SIZE_MULTIPLIER, (Object)Float.valueOf(1.0f));
        builder.define(POWER, (Object)0);
    }

    public void setSpellOrder(CompoundTag order) {
        this.getEntityData().set(SPELL_ORDER, (Object)order);
    }

    public void insertAction(String action) {
        CompoundTag order;
        order.putString((order = this.getSpellOrder()).isEmpty() ? String.valueOf(0) : String.valueOf(order.size()), action);
        this.setSpellOrder(order);
    }

    public CompoundTag getSpellOrder() {
        return (CompoundTag)this.getEntityData().get(SPELL_ORDER);
    }

    public void setSpellType(int type) {
        this.getEntityData().set(SPELL_TYPE, (Object)type);
    }

    public int getSpellType() {
        return (Integer)this.getEntityData().get(SPELL_TYPE);
    }

    public void setColor(int color) {
        this.getEntityData().set(COLOR, (Object)OptionalInt.of(color));
    }

    public OptionalInt getColor() {
        return (OptionalInt)this.getEntityData().get(COLOR);
    }

    public boolean hasColor() {
        return ((OptionalInt)this.getEntityData().get(COLOR)).isPresent();
    }

    public void setFiery(boolean fiery) {
        this.getEntityData().set(FIERY, (Object)fiery);
    }

    public boolean isFiery() {
        return (Boolean)this.getEntityData().get(FIERY);
    }

    public void setLava(boolean lava) {
        this.getEntityData().set(LAVA, (Object)lava);
    }

    public boolean isLava() {
        return (Boolean)this.getEntityData().get(LAVA);
    }

    public void setWater(boolean water) {
        this.getEntityData().set(WATER, (Object)water);
    }

    public boolean isWater() {
        return (Boolean)this.getEntityData().get(WATER);
    }

    public void setCold(boolean cold) {
        this.getEntityData().set(COLD, (Object)cold);
    }

    public boolean isCold() {
        return (Boolean)this.getEntityData().get(COLD);
    }

    public void setSnow(boolean snow) {
        this.getEntityData().set(SNOW, (Object)snow);
    }

    public boolean isSnow() {
        return (Boolean)this.getEntityData().get(SNOW);
    }

    public void setSmoky(boolean smoky) {
        this.getEntityData().set(SMOKY, (Object)smoky);
    }

    public boolean isSmoky() {
        return (Boolean)this.getEntityData().get(SMOKY);
    }

    public void setInky(boolean inky) {
        this.getEntityData().set(INKY, (Object)inky);
    }

    public boolean isInky() {
        return (Boolean)this.getEntityData().get(INKY);
    }

    public void setSilky(boolean snow) {
        this.getEntityData().set(SILKY, (Object)snow);
    }

    public boolean isSilky() {
        return (Boolean)this.getEntityData().get(SILKY);
    }

    public void setSizeMultiplier(float sizeMultiplier) {
        this.getEntityData().set(SIZE_MULTIPLIER, (Object)Float.valueOf(sizeMultiplier));
        this.reapplyPosition();
        this.refreshDimensions();
    }

    public float getSizeMultiplier() {
        return ((Float)this.getEntityData().get(SIZE_MULTIPLIER)).floatValue();
    }

    public float getSizeMultiplier(float max) {
        float sizeMultiplier = this.getSizeMultiplier();
        return sizeMultiplier <= max ? sizeMultiplier : max;
    }

    public void setPower(int power) {
        this.getEntityData().set(POWER, (Object)power);
    }

    public int getPower() {
        return (Integer)this.getEntityData().get(POWER);
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (SIZE_MULTIPLIER.equals(key)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    public EntityDimensions getDimensions(Pose poseIn) {
        return super.getDimensions(poseIn).scale(this.getSizeMultiplier(8.0f));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("SpellOrder", 10)) {
            this.setSpellOrder(compound.getCompound("SpellOrder"));
        }
        if (compound.contains("colorPresent")) {
            this.setColor(compound.getInt("Color"));
        }
        this.setFiery(compound.getBoolean("Fiery"));
        this.setLava(compound.getBoolean("Lava"));
        this.setWater(compound.getBoolean("Water"));
        this.setCold(compound.getBoolean("Cold"));
        this.setSnow(compound.getBoolean("Snow"));
        this.setSmoky(compound.getBoolean("Smoky"));
        this.setInky(compound.getBoolean("Inky"));
        this.setSilky(compound.getBoolean("Silky"));
        this.setSizeMultiplier(compound.getFloat("SizeMultiplier"));
        this.setPower(compound.getInt("PowerAdditive"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (!this.getSpellOrder().isEmpty()) {
            compound.put("SpellOrder", (Tag)this.getSpellOrder());
        }
        compound.putBoolean("colorPresent", this.hasColor());
        if (this.hasColor()) {
            compound.putInt("Color", this.getColor().getAsInt());
        }
        compound.putBoolean("Fiery", this.isFiery());
        compound.putBoolean("Lava", this.isLava());
        compound.putBoolean("Water", this.isWater());
        compound.putBoolean("Cold", this.isCold());
        compound.putBoolean("Snow", this.isSnow());
        compound.putBoolean("Smoky", this.isSmoky());
        compound.putBoolean("Inky", this.isInky());
        compound.putBoolean("Silky", this.isSilky());
        compound.putFloat("SizeMultiplier", this.getSizeMultiplier());
        compound.putInt("PowerAdditive", this.getPower());
    }

    protected boolean shouldBurn() {
        return this.isFiery();
    }

    protected ParticleOptions getTrailParticle() {
        if (this.isLava() && (this.isCold() || this.isSnow() || this.isWater())) {
            return new BlockParticleOption(ParticleTypes.BLOCK, Blocks.STONE.defaultBlockState());
        }
        if (this.isWater() || this.isFiery() && this.isSnow()) {
            return ParticleTypes.DRIPPING_WATER;
        }
        if (this.isSmoky()) {
            return ParticleTypes.SMOKE;
        }
        if (this.isInky()) {
            return ParticleTypes.SQUID_INK;
        }
        if (this.isFiery()) {
            return ParticleTypes.FLAME;
        }
        if (this.isSnow()) {
            return ParticleTypes.ITEM_SNOWBALL;
        }
        return ParticleTypes.WITCH;
    }

    public float getLightLevelDependentMagicValue() {
        return this.isFiery() || this.isLava() ? 1.0f : 0.5f;
    }

    public void tick() {
        if (this.tickCount > 200) {
            this.discard();
        }
        if (this.isCold() || this.isWater()) {
            HitResult result;
            Entity entity = this.getOwner();
            if ((this.level().isClientSide || (entity == null || entity.isAlive()) && this.level().hasChunkAt(this.blockPosition())) && (result = this.rayTraceWater(x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS) {
                this.onHit(result);
            }
        }
        Vec3 vector3d = this.getDeltaMovement();
        this.updateRotation();
        this.setDeltaMovement(vector3d.scale((double)0.99f));
        if (!this.isNoGravity()) {
            Vec3 vector3d1 = this.getDeltaMovement();
            this.setDeltaMovement(vector3d1.x, vector3d1.y - (double)0.02f, vector3d1.z);
        }
        super.tick();
    }

    public HitResult rayTraceWater(Predicate<Entity> entityPredicate) {
        EntityHitResult result;
        Vec3 vector3d2;
        Vec3 position;
        Vec3 deltaMovement = this.getDeltaMovement();
        Level level = this.level();
        BlockHitResult raytraceresult = level.clip(new ClipContext(position = this.position(), vector3d2 = position.add(deltaMovement), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this));
        if (raytraceresult.getType() != HitResult.Type.MISS) {
            vector3d2 = raytraceresult.getLocation();
        }
        if ((result = ProjectileUtil.getEntityHitResult((Level)level, (Entity)this, (Vec3)position, (Vec3)vector3d2, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), entityPredicate)) != null) {
            raytraceresult = result;
        }
        return raytraceresult;
    }

    public void explode() {
        boolean flag = !this.isSnow() && !this.isWater() && this.isFiery();
        int size = (int)Math.ceil(1.0f * this.getSizeMultiplier(16.0f));
        this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)size, flag, flag ? Level.ExplosionInteraction.NONE : Level.ExplosionInteraction.BLOCK);
    }

    public List<BlockPos> getSizedPos(BlockPos pos) {
        if (this.getSizeMultiplier() > 1.0f) {
            int offset = Math.round(this.getSizeMultiplier(16.0f) * 0.5f);
            List<BlockPos> positionList = BlockPos.betweenClosedStream((BlockPos)pos.offset(-offset, -offset, -offset), (BlockPos)pos.offset(offset, offset, offset)).map(BlockPos::immutable).collect(Collectors.toList());
            return positionList;
        }
        return Collections.singletonList(pos);
    }

    public List<Entity> getRangedEntities(Entity hitEntity) {
        if (this.getSizeMultiplier() > 1.0f) {
            double offset = this.getSizeMultiplier(16.0f);
            AABB hitbox = new AABB(hitEntity.getX() - 0.5, hitEntity.getY() - 0.5, hitEntity.getZ() - 0.5, hitEntity.getX() + 0.5, hitEntity.getY() + 0.5, hitEntity.getZ() + 0.5).expandTowards(-offset, -offset, -offset).expandTowards(offset, offset, offset);
            return this.level().getEntities((Entity)this, hitbox, Entity::isAlive);
        }
        return Collections.singletonList(hitEntity);
    }
}

