/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.config;

import com.mrbysco.spelled.Spelled;
import com.mrbysco.spelled.config.SpelledConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.math.NumberUtils;

public class ConfigCache {
    public static Item requiredItem;
    public static Map<Integer, Integer> individualLevelXPCosts;
    public static Map<Integer, ItemCost> individualLevelItemCosts;

    public static void refreshCache() {
        ConfigCache.setRequiredItem((String)SpelledConfig.COMMON.requiredItem.get());
        ConfigCache.generateLevelCostMap((List)SpelledConfig.COMMON.individualLevelCosts.get());
        ConfigCache.generateItemCostMap((List)SpelledConfig.COMMON.individualItemCosts.get());
    }

    public static void setRequiredItem(String value) {
        if (value.isEmpty()) {
            Spelled.LOGGER.error("'requiredItem' is empty, using default");
            requiredItem = Items.LAPIS_LAZULI;
        } else {
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)value));
            if (item != null) {
                requiredItem = item;
            } else {
                Spelled.LOGGER.error("'requiredItem' couldn't be parsed, using default");
                requiredItem = Items.LAPIS_LAZULI;
            }
        }
    }

    public static void generateItemCostMap(List<? extends String> configValues) {
        HashMap<Integer, ItemCost> itemCostMap = new HashMap<Integer, ItemCost>();
        Item defaultItem = requiredItem;
        if (configValues.isEmpty()) {
            Spelled.LOGGER.error("'individualItemCosts' is empty, supplying dummy values");
            for (i = 0; i < 20; ++i) {
                int level = i + 1;
                itemCostMap.put(level, new ItemCost(defaultItem, 10));
            }
        } else {
            for (i = 0; i < configValues.size(); ++i) {
                String configValue = configValues.get(i);
                if (!configValue.contains(",")) {
                    Spelled.LOGGER.error(String.format("Invalid syntax '%s' found in 'individualLevelCosts' config values", configValue));
                    continue;
                }
                String[] values = configValue.split(",");
                if (values.length == 3) {
                    int itemCost;
                    int dummyLevel = i + 1;
                    int dummyItemCost = 5;
                    int level = NumberUtils.isParsable((String)values[0]) ? Integer.parseInt(values[0]) : -1;
                    Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)values[1]));
                    int n = itemCost = NumberUtils.isParsable((String)values[2]) ? Integer.parseInt(values[2]) : -1;
                    if (level == -1) {
                        Spelled.LOGGER.error(String.format("Couldn't parse level value for %s, using dummy value: %s", configValue, dummyLevel));
                        level = dummyLevel;
                    }
                    if (item == null) {
                        Spelled.LOGGER.error(String.format("Couldn't parse specified item %s, using dummy value: %s", values[1], BuiltInRegistries.ITEM.getKey((Object)defaultItem)));
                        item = defaultItem;
                    }
                    if (itemCost == -1) {
                        Spelled.LOGGER.error(String.format("Couldn't parse item cost value for %s, using dummy value: %s", configValue, dummyItemCost));
                        itemCost = dummyItemCost;
                    }
                    itemCostMap.put(level, new ItemCost(item, itemCost));
                    continue;
                }
                Spelled.LOGGER.error(String.format("Not enough data specified. Couldn't locate Level, XP cost and item cost inside of specified %s. Are you sure you used ,'s ?", configValue));
            }
        }
        int maxLevel = (Integer)SpelledConfig.COMMON.maxLevel.get();
        if (((Boolean)SpelledConfig.COMMON.individualItems.get()).booleanValue() && itemCostMap.size() < maxLevel) {
            Spelled.LOGGER.error("Individual items is enabled but there aren't enough items supplied in 'individualItemCosts'.");
            Spelled.LOGGER.error(String.format("Currently 'individualItemCosts' only has %s out of %s items supplied.", itemCostMap.size(), maxLevel));
            int currentAmount = itemCostMap.size();
            int amountMissing = maxLevel - itemCostMap.size();
            for (int i = 0; i < amountMissing; ++i) {
                itemCostMap.put(currentAmount + (i + 1), new ItemCost(defaultItem, 10));
            }
        }
        individualLevelItemCosts = itemCostMap;
    }

    public static void generateLevelCostMap(List<? extends String> configValues) {
        HashMap<Integer, Integer> xpCostMap = new HashMap<Integer, Integer>();
        if (configValues.isEmpty()) {
            Spelled.LOGGER.error("individualLevelCosts is empty, supplying dummy values");
            for (i = 0; i < 20; ++i) {
                int level = i + 1;
                xpCostMap.put(level, 5);
            }
        } else {
            for (i = 0; i < configValues.size(); ++i) {
                String configValue = configValues.get(i);
                if (!configValue.contains(",")) {
                    Spelled.LOGGER.error(String.format("Invalid syntax '%s' found in 'individualLevelCosts' config values", configValue));
                    continue;
                }
                String[] values = configValue.split(",");
                if (values.length == 2) {
                    int cost;
                    int dummyLevel = i + 1;
                    int dummyCost = 5;
                    int level = NumberUtils.isParsable((String)values[0]) ? Integer.parseInt(values[0]) : -1;
                    int n = cost = NumberUtils.isParsable((String)values[1]) ? Integer.parseInt(values[1]) : -1;
                    if (level == -1) {
                        Spelled.LOGGER.error(String.format("Couldn't parse level value for %s, using dummy value: %s", configValue, dummyLevel));
                        level = dummyLevel;
                    }
                    if (cost == -1) {
                        Spelled.LOGGER.error(String.format("Couldn't parse cost value for %s, using dummy value: %s", configValue, dummyCost));
                        cost = dummyCost;
                    }
                    xpCostMap.put(level, cost);
                    continue;
                }
                Spelled.LOGGER.error(String.format("Not enough data specified. Couldn't locate Level and XP cost in specified %s. Are you sure you separated with a , ?", configValue));
            }
        }
        int maxLevel = (Integer)SpelledConfig.COMMON.maxLevel.get();
        if (((Boolean)SpelledConfig.COMMON.individualLevels.get()).booleanValue() && xpCostMap.size() < maxLevel) {
            Spelled.LOGGER.error("Individual levels is enabled but there aren't enough costs supplied in 'individualLevelCosts'.");
            Spelled.LOGGER.error(String.format("Currently 'individualLevelCosts' only has %s out of %s levels supplied.", xpCostMap.size(), maxLevel));
            int currentAmount = xpCostMap.size();
            int amountMissing = maxLevel - xpCostMap.size();
            for (int i = 0; i < amountMissing; ++i) {
                xpCostMap.put(currentAmount + (i + 1), 5);
            }
        }
        individualLevelXPCosts = xpCostMap;
    }

    public record ItemCost(Item item, int cost) {
        public Item getItem() {
            return this.item;
        }

        public int getCost() {
            return this.cost;
        }
    }
}

