/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.compat.jei;

import com.mrbysco.spelled.Reference;
import com.mrbysco.spelled.registry.SpelledComponents;
import com.mrbysco.spelled.registry.SpelledRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation UID = Reference.modLoc("jei_plugin");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)SpelledRegistry.KNOWLEDGE_TOME.get()), (ISubtypeInterpreter)new TomeSubTypes());
    }

    private static class TomeSubTypes
    implements ISubtypeInterpreter<ItemStack> {
        private TomeSubTypes() {
        }

        @Nullable
        public Object getSubtypeData(ItemStack ingredient, UidContext context) {
            return ingredient.get(SpelledComponents.UNLOCK);
        }

        public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
            String tomeUnlock = (String)ingredient.getOrDefault(SpelledComponents.UNLOCK, (Object)"");
            if (tomeUnlock.isEmpty()) {
                return "";
            }
            return String.valueOf(BuiltInRegistries.ITEM.getKey((Object)ingredient.getItem())) + "@" + tomeUnlock;
        }
    }
}

