/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mrbysco.spelled.Reference;
import com.mrbysco.spelled.entity.SpellEntity;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class SpellRenderer
extends EntityRenderer<SpellEntity> {
    private static final ResourceLocation PROJECTILE_TEXTURE = Reference.modLoc("textures/item/projectile.png");
    private static final ResourceLocation BALL_TEXTURE = Reference.modLoc("textures/item/ball.png");
    private static final ResourceLocation LAVA_TEXTURE = Reference.modLoc("textures/item/lava_ball.png");
    private static final ResourceLocation WATER_TEXTURE = Reference.modLoc("textures/item/water_ball.png");
    private static final RenderType renderType = RenderType.entityCutoutNoCull((ResourceLocation)BALL_TEXTURE);
    private static Color color = null;

    public SpellRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    protected int getBlockLightLevel(SpellEntity entityIn, BlockPos partialTicks) {
        return 15;
    }

    public void render(SpellEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.pushPose();
        this.preRenderCallback(entityIn, poseStack, partialTicks);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        PoseStack.Pose last = poseStack.last();
        Matrix4f pose = last.pose();
        VertexConsumer buffer = bufferIn.getBuffer(renderType);
        SpellRenderer.vertex(buffer, pose, last, packedLightIn, 0.0f, 0, 0, 1);
        SpellRenderer.vertex(buffer, pose, last, packedLightIn, 1.0f, 0, 1, 1);
        SpellRenderer.vertex(buffer, pose, last, packedLightIn, 1.0f, 1, 1, 0);
        SpellRenderer.vertex(buffer, pose, last, packedLightIn, 0.0f, 1, 0, 0);
        poseStack.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    private static void vertex(VertexConsumer vertexBuilder, Matrix4f pose, PoseStack.Pose last, int packedLightIn, float p_229045_4_, int p_229045_5_, int p_229045_6_, int p_229045_7_) {
        vertexBuilder.addVertex(pose, p_229045_4_ - 0.5f, (float)p_229045_5_ - 0.25f, 0.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).setUv((float)p_229045_6_, (float)p_229045_7_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLightIn).setNormal(last, 0.0f, 1.0f, 0.0f);
    }

    protected void preRenderCallback(SpellEntity entityIn, PoseStack poseStack, float partialTickTime) {
        float sizeMultiplier;
        if (color == null) {
            color = new Color(255, 255, 255, 255);
        }
        if (entityIn.hasColor() && !color.equals(new Color(entityIn.getColor().getAsInt()))) {
            color = new Color(entityIn.getColor().getAsInt());
        }
        if ((sizeMultiplier = entityIn.getSizeMultiplier() / 2.0f) > 8.0f) {
            sizeMultiplier = 8.0f;
        }
        poseStack.scale(1.0f, 1.0f, 1.0f);
        poseStack.translate(0.0, (double)0.001f, 0.0);
        float f3 = 1.0f;
        poseStack.scale(f3 * sizeMultiplier, f3 * sizeMultiplier, f3 * sizeMultiplier);
    }

    public ResourceLocation getTextureLocation(SpellEntity entity) {
        if (entity.isWater()) {
            return WATER_TEXTURE;
        }
        if (entity.isLava()) {
            return LAVA_TEXTURE;
        }
        if (entity.getSpellType() == 1) {
            return PROJECTILE_TEXTURE;
        }
        return BALL_TEXTURE;
    }
}

