/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.client.gui.book;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.spelled.client.gui.book.AdjectiveEntry;
import com.mrbysco.spelled.client.gui.book.AdjectiveListWidget;
import com.mrbysco.spelled.packets.message.SignSpellPayload;
import com.mrbysco.spelled.registry.SpelledComponents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.loading.StringUtils;
import net.neoforged.neoforge.network.PacketDistributor;

public class SpellBookScreen
extends Screen {
    private static final ResourceLocation SLOT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot");
    private static final Component EDIT_TITLE_LABEL = Component.translatable((String)"spelled.book.editTitle");
    private static final Component FINALIZE_WARNING_LABEL = Component.translatable((String)"spelled.book.finalizeWarning");
    private static final FormattedCharSequence GRAY_CURSOR = FormattedCharSequence.forward((String)"_", (Style)Style.EMPTY.withColor(ChatFormatting.GRAY));
    private static final FormattedCharSequence WHITE_CURSOR = FormattedCharSequence.forward((String)"_", (Style)Style.EMPTY.withColor(ChatFormatting.WHITE));
    private static final int PADDING = 6;
    private final List<String> selectedAdjectives = new ArrayList<String>();
    private String typeWord = "";
    private AdjectiveListWidget adjectiveWidget;
    private AdjectiveListWidget.ListEntry focused = null;
    private final List<AdjectiveEntry> unsortedAdjectives;
    private List<AdjectiveEntry> adjectives;
    private Button insertButton;
    private Button removeButton;
    private Button signButton;
    private Button finalizeButton;
    private String title = "";
    private final TextFieldHelper titleEdit = new TextFieldHelper(() -> this.title, message -> {
        this.title = message;
    }, this::getClipboard, this::setClipboard, message -> message.length() < 32);
    private final int buttonMargin = 1;
    private final int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private EditBox search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;
    private final Player owner;
    private final InteractionHand hand;
    private final ItemStack stack;
    private boolean isSigning;
    private boolean isModified;
    private int frameTick;
    private final Component ownerText;

    public SpellBookScreen(List<AdjectiveEntry> entries, Player player, InteractionHand hand) {
        super((Component)Component.translatable((String)"spelled.spell_book.screen"));
        this.hand = hand;
        this.owner = player;
        this.stack = player.getItemInHand(hand);
        ArrayList<AdjectiveEntry> sortedEntries = new ArrayList<AdjectiveEntry>(entries);
        Collections.sort(sortedEntries);
        this.unsortedAdjectives = Collections.unmodifiableList(sortedEntries);
        this.adjectives = Collections.unmodifiableList(entries);
        this.ownerText = Component.translatable((String)"book.byAuthor", (Object[])new Object[]{player.getName()}).withStyle(ChatFormatting.GRAY);
        if (this.stack.has(SpelledComponents.SPELL)) {
            String currentSpell = (String)this.stack.getOrDefault(SpelledComponents.SPELL, (Object)"");
            String[] words = currentSpell.split(" ");
            List<String> wordList = Arrays.asList(words);
            String type = wordList.get(wordList.size() - 1);
            wordList = wordList.subList(0, wordList.size() - 1);
            this.selectedAdjectives.addAll(wordList);
            this.typeWord = type;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        int centerWidth = this.width / 2;
        int listWidth = 0;
        for (AdjectiveEntry adjectiveEntry : this.adjectives) {
            listWidth = Math.max(listWidth, this.getFont().width(adjectiveEntry.getAdjectiveName()) + 10);
        }
        int structureWidth = this.width - (listWidth += (listWidth = Math.max(Math.min(listWidth, this.width / 3), 200)) % this.numButtons != 0 ? this.numButtons - listWidth % this.numButtons : 0) - 18;
        int closeButtonWidth = Math.min(structureWidth, 200);
        int y = this.height - 20 - 6;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            if (this.isSigning) {
                this.isSigning = false;
            } else {
                this.onClose();
            }
            this.updateButtonVisibility();
        }).bounds(centerWidth - closeButtonWidth / 2 + 6, y, closeButtonWidth, 20).build());
        this.insertButton = Button.builder((Component)Component.translatable((String)"spelled.screen.selection.select"), button -> {
            if (this.focused != null) {
                if (this.focused.isType()) {
                    this.typeWord = this.focused.getAdjectiveName();
                } else {
                    this.selectedAdjectives.add(this.focused.getAdjectiveName());
                }
            }
        }).bounds(centerWidth - closeButtonWidth / 2 + 6, y -= 24, closeButtonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.insertButton);
        this.removeButton = Button.builder((Component)Component.translatable((String)"spelled.screen.selection.remove"), button -> {
            if (this.selectedAdjectives.size() == 1) {
                this.selectedAdjectives.clear();
            } else if (!this.selectedAdjectives.isEmpty()) {
                this.selectedAdjectives.remove(this.selectedAdjectives.size() - 1);
            }
        }).bounds(centerWidth - closeButtonWidth / 2 + 6, y -= 24, closeButtonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.removeButton);
        this.search = new EditBox(this.getFont(), centerWidth - listWidth / 2 + 6 + 1, y -= 20, listWidth - 2, 14, (Component)Component.translatable((String)"spelled.screen.search"));
        int fullButtonHeight = 32;
        Objects.requireNonNull(this.getFont());
        this.adjectiveWidget = new AdjectiveListWidget(this, this.width, fullButtonHeight, (y -= 30) - 9 - 6);
        this.adjectiveWidget.setX(0);
        this.addWidget((GuiEventListener)this.search);
        this.addWidget((GuiEventListener)this.adjectiveWidget);
        this.setInitialFocus((GuiEventListener)this.search);
        int width = listWidth / this.numButtons;
        int x = centerWidth + 6 - width;
        SortType.A_TO_Z.button = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)SortType.A_TO_Z.getButtonText(), button -> this.resortAdjectives(SortType.A_TO_Z)).bounds(x, 6, width - 1, 20).build());
        SortType.Z_TO_A.button = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)SortType.Z_TO_A.getButtonText(), button -> this.resortAdjectives(SortType.Z_TO_A)).bounds(x += width + 1, 6, width - 1, 20).build());
        this.signButton = Button.builder((Component)Component.translatable((String)"spelled.book.finalizeButton"), button -> {
            this.isSigning = true;
            this.updateButtonVisibility();
        }).bounds(this.width - 66, 6, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)this.signButton);
        this.finalizeButton = Button.builder((Component)Component.translatable((String)"book.signButton"), button -> {
            if (this.isSigning) {
                this.saveChanges(true);
                this.minecraft.setScreen((Screen)null);
            }
        }).bounds(centerWidth - closeButtonWidth / 2 + 6, this.height - 50 - 6, closeButtonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.finalizeButton);
        this.updateButtonVisibility();
        this.resortAdjectives(SortType.A_TO_Z);
        this.updateCache();
    }

    private Component getFinalizeTooltip() {
        boolean flag = this.selectedAdjectives.isEmpty();
        boolean flag2 = this.typeWord.isEmpty();
        if (flag || flag2) {
            StringBuilder builder = new StringBuilder();
            if (flag) {
                builder.append(I18n.get((String)"spelled.screen.missing_adjectives", (Object[])new Object[0])).append(" ");
            }
            if (flag2) {
                builder.append(I18n.get((String)"spelled.screen.missing_type", (Object[])new Object[0]));
            }
            String errorMessage = builder.toString();
            return Component.literal((String)errorMessage);
        }
        return Component.empty();
    }

    private void updateButtonVisibility() {
        this.signButton.visible = !this.isSigning;
        this.insertButton.visible = !this.isSigning;
        this.removeButton.visible = !this.isSigning;
        this.finalizeButton.visible = this.isSigning;
        this.finalizeButton.active = !this.title.trim().isEmpty();
        SortType.A_TO_Z.button.visible = !this.isSigning;
        SortType.Z_TO_A.button.visible = !this.isSigning;
    }

    public void tick() {
        this.signButton.setTooltip(Tooltip.create((Component)this.getFinalizeTooltip()));
        super.tick();
        ++this.frameTick;
        if (!this.isSigning) {
            this.signButton.active = !this.selectedAdjectives.isEmpty() && !this.typeWord.isEmpty();
            this.adjectiveWidget.setSelected((AbstractSelectionList.Entry)this.focused);
            if (!this.search.getValue().equals(this.lastFilterText)) {
                this.reloadAdjectives();
                this.sorted = false;
            }
            if (!this.sorted) {
                this.reloadAdjectives();
                if (this.sortType == SortType.A_TO_Z) {
                    Collections.sort(this.adjectives);
                } else if (this.sortType == SortType.Z_TO_A) {
                    this.adjectives.sort(Collections.reverseOrder());
                }
                this.adjectiveWidget.refreshList();
                if (this.focused != null) {
                    this.focused = this.adjectiveWidget.children().stream().filter(e -> e == this.focused).findFirst().orElse(null);
                    this.updateCache();
                }
                this.sorted = true;
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isSigning) {
            int i = (this.width - 192) / 2;
            int j = this.height / 2 - 100;
            boolean flag = this.frameTick / 6 % 2 == 0;
            FormattedCharSequence formattedCharSequence = FormattedCharSequence.composite((FormattedCharSequence)FormattedCharSequence.forward((String)this.title, (Style)Style.EMPTY), (FormattedCharSequence)(flag ? GRAY_CURSOR : WHITE_CURSOR));
            int k = this.font.width((FormattedText)EDIT_TITLE_LABEL);
            guiGraphics.drawString(this.font, EDIT_TITLE_LABEL, i + 36 + (114 - k) / 2, (int)(34.0f + (float)j), 0xFFFFFF, false);
            int l = this.font.width(formattedCharSequence);
            guiGraphics.drawString(this.font, formattedCharSequence, (float)(i + 36 + (114 - l) / 2), 50.0f + (float)j, 0xFFFFFF, false);
            int i1 = this.font.width((FormattedText)this.ownerText);
            guiGraphics.drawString(this.font, this.ownerText, i + 36 + (114 - i1) / 2, (int)(60.0f + (float)j), 0xFFFFFF, false);
            guiGraphics.drawWordWrap(this.font, (FormattedText)FINALIZE_WARNING_LABEL, i + 36, 82 + j, 114, 0xFFFFFF);
        } else {
            this.adjectiveWidget.render(guiGraphics, mouseX, mouseY, partialTicks);
            MutableComponent text = Component.translatable((String)"spelled.screen.search");
            int n = this.width / 2 + 6;
            int n2 = this.search.getY();
            Objects.requireNonNull(this.font);
            guiGraphics.drawCenteredString(this.font, (Component)text, n, n2 - 9 - 2, 0xFFFFFF);
            this.search.render(guiGraphics, mouseX, mouseY, partialTicks);
            guiGraphics.drawString(this.font, this.getTitle(), 5, 5, 0xFFFFFF, false);
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 100.0f);
            RenderSystem.enableDepthTest();
            int itemX = this.width / 2 - 2;
            int itemY = this.height - 130;
            guiGraphics.blitSprite(SLOT_SPRITE, itemX - 1, itemY - 1, 0, 18, 18);
            guiGraphics.renderItem(this.stack, itemX, itemY);
            guiGraphics.renderItemDecorations(this.font, this.stack, itemX, itemY, null);
            RenderSystem.disableDepthTest();
            poseStack.popPose();
            if (this.isHovering(itemX - 16, itemY, itemX + 16, itemY + 24, mouseX, mouseY)) {
                boolean flag = this.selectedAdjectives.isEmpty();
                boolean flag2 = this.typeWord.isEmpty();
                StringBuilder builder = new StringBuilder();
                if (this.selectedAdjectives.isEmpty()) {
                    builder.append(I18n.get((String)"spelled.screen.missing_adjectives", (Object[])new Object[0])).append(" ");
                } else {
                    this.selectedAdjectives.forEach(adjective -> builder.append((String)adjective).append(" "));
                }
                MutableComponent component = Component.literal((String)builder.toString());
                StringBuilder builder2 = new StringBuilder();
                if (this.typeWord.isEmpty()) {
                    builder2.append(I18n.get((String)"spelled.screen.missing_type", (Object[])new Object[0]));
                } else {
                    builder2.append(this.typeWord);
                }
                MutableComponent component2 = Component.literal((String)builder2.toString());
                if (flag) {
                    component.withStyle(ChatFormatting.RED);
                }
                if (flag2) {
                    component2.withStyle(ChatFormatting.RED);
                }
                MutableComponent finalComponent = component.append((Component)component2);
                guiGraphics.renderTooltip(this.font, (Component)finalComponent, mouseX, mouseY);
            }
        }
    }

    protected boolean isHovering(int x, int y, int x2, int y2, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX < (double)x2 && mouseY >= (double)y && mouseY <= (double)y2;
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildAdjectiveList(Consumer<T> ListViewConsumer, Function<AdjectiveEntry, T> newEntry) {
        this.adjectives.forEach(mod -> ListViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((AdjectiveEntry)mod)));
    }

    private void reloadAdjectives() {
        this.lastFilterText = this.search.getValue();
        this.adjectives = this.unsortedAdjectives.stream().filter(word -> {
            boolean flag = StringUtils.toLowerCase((String)word.getAdjectiveName()).contains(StringUtils.toLowerCase((String)this.lastFilterText));
            boolean flag2 = StringUtils.toLowerCase((String)word.getAdjectiveDescription().getString()).contains(StringUtils.toLowerCase((String)this.lastFilterText));
            return flag || flag2;
        }).collect(Collectors.toList());
    }

    private void resortAdjectives(SortType newSort) {
        this.sortType = newSort;
        for (SortType sort : SortType.values()) {
            if (sort.button == null) continue;
            sort.button.active = this.sortType != sort;
        }
        this.sorted = false;
    }

    public void setFocused(AdjectiveListWidget.ListEntry entry) {
        this.focused = entry == this.focused ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        this.insertButton.active = this.focused != null;
    }

    public void resize(Minecraft mc, int newWidth, int newHeight) {
        super.resize(mc, newHeight, newHeight);
        String s = this.search.getValue();
        SortType sort = this.sortType;
        AdjectiveListWidget.ListEntry focused = this.focused;
        this.init(mc, newWidth, newHeight);
        this.search.setValue(s);
        this.focused = focused;
        if (!this.search.getValue().isEmpty()) {
            this.reloadAdjectives();
        }
        if (sort != SortType.NORMAL) {
            this.resortAdjectives(sort);
        }
        this.updateCache();
    }

    public void onClose() {
        super.onClose();
        this.minecraft.setScreen(null);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.setScreen((Screen)null);
            return true;
        }
        if (this.isSigning) {
            return this.titleKeyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char keyCode, int modifiers) {
        if (super.charTyped(keyCode, modifiers)) {
            return true;
        }
        if (this.isSigning) {
            boolean flag = this.titleEdit.charTyped(keyCode);
            if (flag) {
                this.updateButtonVisibility();
                this.isModified = true;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean titleKeyPressed(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 257: 
            case 335: {
                if (!this.title.isEmpty()) {
                    this.saveChanges(true);
                    this.minecraft.setScreen((Screen)null);
                }
                return true;
            }
            case 259: {
                this.titleEdit.removeCharsFromCursor(-1);
                this.updateButtonVisibility();
                this.isModified = true;
                return true;
            }
        }
        return false;
    }

    private void saveChanges(boolean finalize) {
        if (this.isModified) {
            StringBuilder builder = new StringBuilder();
            if (!this.selectedAdjectives.isEmpty()) {
                this.selectedAdjectives.forEach(adjective -> builder.append((String)adjective).append(" "));
            }
            builder.append(this.typeWord);
            String spell = builder.toString();
            this.stack.set(SpelledComponents.SPELL, (Object)spell);
            int i = this.hand == InteractionHand.MAIN_HAND ? this.owner.getInventory().selected : 40;
            PacketDistributor.sendToServer((CustomPacketPayload)new SignSpellPayload(this.stack, finalize, this.title.trim(), spell, i), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void setClipboard(String clipboard) {
        if (this.minecraft != null) {
            TextFieldHelper.setClipboardContents((Minecraft)this.minecraft, (String)clipboard);
        }
    }

    private String getClipboard() {
        return this.minecraft != null ? TextFieldHelper.getClipboardContents((Minecraft)this.minecraft) : "";
    }

    public void removed() {
        super.removed();
    }

    private static enum SortType {
        NORMAL,
        A_TO_Z,
        Z_TO_A;

        Button button;

        Component getButtonText() {
            return Component.translatable((String)("spelled.screen.search." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

