/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.client.gui.book;

import com.mrbysco.spelled.client.gui.book.AdjectiveEntry;
import com.mrbysco.spelled.client.gui.book.SpellBookScreen;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class AdjectiveListWidget
extends ObjectSelectionList<ListEntry> {
    private final int listWidth;
    private final SpellBookScreen parent;

    public AdjectiveListWidget(SpellBookScreen parent, int listWidth, int top, int bottom) {
        Minecraft minecraft = parent.getMinecraft();
        Objects.requireNonNull(parent.getFont());
        super(minecraft, listWidth, bottom - top, top, 9 * 2 + 8);
        this.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
    }

    protected int getScrollbarPosition() {
        return this.listWidth;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public void refreshList() {
        this.clearEntries();
        this.parent.buildAdjectiveList(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0), mod -> new ListEntry((AdjectiveEntry)mod, this.parent));
    }

    public class ListEntry
    extends ObjectSelectionList.Entry<ListEntry> {
        private final AdjectiveEntry adjective;
        private final SpellBookScreen parent;

        ListEntry(AdjectiveEntry adjective, SpellBookScreen parent) {
            this.adjective = adjective;
            this.parent = parent;
        }

        public void render(GuiGraphics guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovering, float partialTicks) {
            MutableComponent name = Component.literal((String)this.getAdjectiveName());
            Font font = this.parent.getFont();
            int color = this.isType() ? 16351261 : 0xFFFFFF;
            guiGraphics.drawString(font, Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{font.substrByWidth((FormattedText)name, AdjectiveListWidget.this.listWidth)})), this.parent.width / 2 - font.width((FormattedText)name) / 2 + 3, top + 6, color, false);
            if (isHovering) {
                guiGraphics.renderTooltip(font, this.getDescription(), mouseX, mouseY);
            }
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.parent.setFocused(this);
            AdjectiveListWidget.this.setSelected((AbstractSelectionList.Entry)this);
            return false;
        }

        public String getAdjectiveName() {
            return this.adjective.getAdjectiveName();
        }

        public Component getDescription() {
            if (this.isType()) {
                return Component.literal((String)"Type: ").withStyle(ChatFormatting.GOLD).append(this.adjective.getAdjectiveDescription());
            }
            return this.adjective.getAdjectiveDescription();
        }

        public boolean isType() {
            return this.adjective.isType();
        }

        public int getSlots() {
            return this.adjective.getSlots();
        }

        public Component getNarration() {
            return this.getDescription();
        }
    }
}

