/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mrbysco.spelled.Reference;
import com.mrbysco.spelled.config.SpelledConfig;
import com.mrbysco.spelled.menu.AltarMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class AltarScreen
extends AbstractContainerScreen<AltarMenu> {
    private static final ResourceLocation ALTAR_GUI_TEXTURE = Reference.modLoc("textures/gui/container/leveling_altar.png");
    private static final ResourceLocation ALTAR_GUI_SLOTLESS_TEXTURE = Reference.modLoc("textures/gui/container/leveling_altar_no_slot.png");
    private static final ResourceLocation ALTAR_BOOK_TEXTURE = Reference.modLoc("textures/entity/altar_book.png");
    private BookModel bookModel;
    private final Random random = new Random();
    public int ticks;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    private ItemStack last = ItemStack.EMPTY;

    public AltarScreen(AltarMenu container, Inventory playerInventory, Component textComponent) {
        super((AbstractContainerMenu)container, playerInventory, textComponent);
    }

    protected void init() {
        super.init();
        this.bookModel = new BookModel(this.minecraft.getEntityModels().bakeLayer(ModelLayers.BOOK));
    }

    protected void containerTick() {
        super.containerTick();
        this.tickBook();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.bookHovered(mouseX, mouseY)) {
            Minecraft mc = this.minecraft;
            if (mc != null && mc.gameMode != null) {
                mc.gameMode.handleInventoryButtonClick(((AltarMenu)this.menu).containerId, 0);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean bookHovered(double mouseX, double mouseY) {
        int levelCost = ((AltarMenu)this.menu).getCurrentLevelCost();
        return this.isHovering(74, 20, 28, 22, mouseX, mouseY) && levelCost > 0;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        LocalPlayer player = this.minecraft != null ? this.minecraft.player : null;
        int levelCost = ((AltarMenu)this.menu).getCurrentLevelCost();
        int itemAmountCost = ((AltarMenu)this.menu).getItemCostAmount();
        boolean itemFlag = (Boolean)SpelledConfig.COMMON.requireItems.get() != false && itemAmountCost > 0 && ((AltarMenu)this.menu).getCostStackCount() < itemAmountCost;
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        ResourceLocation texture = (Boolean)SpelledConfig.COMMON.requireItems.get() != false ? ALTAR_GUI_TEXTURE : ALTAR_GUI_SLOTLESS_TEXTURE;
        guiGraphics.blit(texture, i, j, 0, 0, this.imageWidth, this.imageHeight);
        this.renderBook(guiGraphics, i, j, mouseX, mouseY, partialTicks, levelCost, itemFlag);
        int j1 = i + 60;
        int k1 = j1 + 20;
        Object s = "";
        s = levelCost > 0 ? (String)s + levelCost : (String)s + "\u221e";
        int j2 = player != null && (itemFlag || player.experienceLevel < levelCost) && !player.getAbilities().instabuild ? 4226832 : 8453920;
        if (levelCost == -1) {
            j2 = 0xFFAA00;
        }
        guiGraphics.drawCenteredString(this.font, (String)s, k1 + 8, j + 44, j2);
    }

    private void renderBook(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTick, int levelCost, boolean itemFlag) {
        LocalPlayer player = this.minecraft != null ? this.minecraft.player : null;
        float f = Mth.lerp((float)partialTick, (float)this.oOpen, (float)this.open);
        float f1 = Mth.lerp((float)partialTick, (float)this.oFlip, (float)this.flip);
        Lighting.setupForEntityInInventory();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x + 88.0f, (float)y + 28.0f, 100.0f);
        float f2 = 40.0f;
        guiGraphics.pose().scale(-f2, f2, f2);
        guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(25.0f));
        guiGraphics.pose().translate((1.0f - f) * 0.2f, (1.0f - f) * 0.1f, (1.0f - f) * 0.25f);
        float f3 = -(1.0f - f) * 90.0f - 90.0f;
        guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(f3));
        guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(180.0f));
        float f4 = Mth.clamp((float)(Mth.frac((float)(f1 + 0.25f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        float f5 = Mth.clamp((float)(Mth.frac((float)(f1 + 0.75f)) * 1.6f - 0.3f), (float)0.0f, (float)1.0f);
        boolean flag = true;
        if (player != null) {
            flag = levelCost > 0 && (itemFlag || player.experienceLevel < levelCost) && !player.getAbilities().instabuild;
        }
        this.bookModel.setupAnim(0.0f, f4, f5, f);
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        VertexConsumer vertexconsumer = guiGraphics.bufferSource().getBuffer(this.bookModel.renderType(ALTAR_BOOK_TEXTURE));
        boolean bookHovered = this.bookHovered(mouseX, mouseY);
        if (bookHovered) {
            if (flag) {
                red = 0.6f;
                green = 0.4f;
            } else {
                red = 0.4f;
                green = 0.6f;
            }
            blue = 0.4f;
        } else if (flag) {
            red = 0.6f;
            green = 0.6f;
            blue = 0.6f;
        }
        this.bookModel.renderToBuffer(guiGraphics.pose(), vertexconsumer, 0xF000F0, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)red, (float)green, (float)blue, (float)1.0f));
        guiGraphics.flush();
        guiGraphics.pose().popPose();
        Lighting.setupFor3DItems();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        boolean flag;
        LocalPlayer player;
        LocalPlayer localPlayer = player = this.minecraft != null ? this.minecraft.player : null;
        if (this.minecraft != null) {
            partialTicks = this.minecraft.getFrameTimeNs();
        }
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        boolean bl = flag = player != null && player.getAbilities().instabuild;
        if (this.bookHovered(mouseX, mouseY) && !flag) {
            boolean noXP;
            int levelCost = ((AltarMenu)this.menu).getCurrentLevelCost();
            ArrayList list = Lists.newArrayList();
            boolean bl2 = levelCost > 0 && (player == null ? 0 : player.experienceLevel) < levelCost ? true : (noXP = false);
            MutableComponent mutableComponent = noXP ? Component.translatable((String)"spelled:container.altar.level.requirement", (Object[])new Object[]{levelCost}) : (levelCost == 1 ? Component.translatable((String)"spelled:container.altar.level.one") : Component.translatable((String)"spelled:container.altar.level.many", (Object[])new Object[]{levelCost}));
            if (((Boolean)SpelledConfig.COMMON.requireItems.get()).booleanValue()) {
                int stackCount = ((AltarMenu)this.menu).getCostStackCount();
                Item itemCost = ((AltarMenu)this.menu).getItemCost();
                int itemAmountCost = ((AltarMenu)this.menu).getItemCostAmount();
                boolean noItems = itemAmountCost > 0 && itemCost != Items.AIR && stackCount <= itemAmountCost;
                list.add(mutableComponent.withStyle(noXP ? ChatFormatting.RED : ChatFormatting.GREEN));
                MutableComponent iformattabletextcomponent1 = noItems ? Component.translatable((String)"spelled:container.altar.item.requirement", (Object[])new Object[]{itemAmountCost, itemCost.getDescription()}) : Component.translatable((String)"spelled:container.altar.item", (Object[])new Object[]{itemAmountCost, itemCost.getDescription()});
                list.add(iformattabletextcomponent1.withStyle(noItems ? ChatFormatting.RED : ChatFormatting.GREEN));
            }
            guiGraphics.renderComponentTooltip(this.font, (List)list, mouseX, mouseY);
        }
    }

    public void tickBook() {
        ItemStack itemstack;
        if (((Boolean)SpelledConfig.COMMON.requireItems.get()).booleanValue() && !ItemStack.matches((ItemStack)(itemstack = ((AltarMenu)this.menu).getSlot(0).getItem()), (ItemStack)this.last)) {
            this.last = itemstack;
            do {
                this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (this.flip <= this.flipT + 1.0f && this.flip >= this.flipT - 1.0f);
        }
        ++this.ticks;
        this.oFlip = this.flip;
        this.oOpen = this.open;
        boolean flag = false;
        int currentLevel = ((AltarMenu)this.menu).getCurrentLevel();
        if (((AltarMenu)this.menu).levelCosts.length > currentLevel && ((AltarMenu)this.menu).getCurrentLevelCost() > 0) {
            flag = true;
        }
        this.open = flag ? (this.open += 0.2f) : (this.open -= 0.2f);
        this.open = Mth.clamp((float)this.open, (float)0.0f, (float)1.0f);
        float f1 = (this.flipT - this.flip) * 0.4f;
        float f = 0.2f;
        f1 = Mth.clamp((float)f1, (float)-0.2f, (float)0.2f);
        this.flipA += (f1 - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }
}

