/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.block;

import com.mojang.serialization.MapCodec;
import com.mrbysco.spelled.api.SpelledAPI;
import com.mrbysco.spelled.blockentity.LevelingAltarBlockEntity;
import com.mrbysco.spelled.menu.AltarMenu;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class LevelingAltarBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<LevelingAltarBlock> CODEC = LevelingAltarBlock.simpleCodec(LevelingAltarBlock::new);
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape FALLBACK = Block.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0);
    protected static final VoxelShape SHAPE = Stream.of(Block.box((double)8.08182, (double)0.75, (double)7.423660000000002, (double)15.08182, (double)12.75, (double)8.423660000000002), Block.box((double)13.33182, (double)12.0, (double)7.173660000000002, (double)15.33182, (double)13.0, (double)8.673660000000002), Block.box((double)14.33182, (double)1.5, (double)7.173660000000002, (double)15.33182, (double)2.5, (double)8.673660000000002), Block.box((double)14.33182, (double)11.0, (double)7.173660000000002, (double)15.33182, (double)12.0, (double)8.673660000000002), Block.box((double)13.33182, (double)0.5, (double)7.173660000000002, (double)15.33182, (double)1.5, (double)8.673660000000002), Block.box((double)7.0, (double)0.5, (double)7.500000000000002, (double)9.0, (double)13.0, (double)8.500000000000002), Block.box((double)0.68804, (double)0.5, (double)7.273510000000002, (double)2.68804, (double)1.5, (double)8.773510000000002), Block.box((double)0.68804, (double)1.5, (double)7.273510000000002, (double)1.68804, (double)2.5, (double)8.773510000000002), Block.box((double)0.68804, (double)11.0, (double)7.273510000000002, (double)1.68804, (double)12.0, (double)8.773510000000002), Block.box((double)0.68804, (double)12.0, (double)7.273510000000002, (double)2.68804, (double)13.0, (double)8.773510000000002), Block.box((double)0.93804, (double)0.75, (double)7.523510000000002, (double)7.93804, (double)12.75, (double)8.523510000000002), Block.box((double)7.75, (double)1.5, (double)7.250000000000002, (double)8.25, (double)12.0, (double)7.500000000000002)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape SHAPE_2 = Stream.of(Block.box((double)7.492089999999999, (double)0.75, (double)0.9899700000000013, (double)8.49209, (double)12.75, (double)7.989970000000001), Block.box((double)7.242089999999999, (double)12.0, (double)0.7399700000000013, (double)8.74209, (double)13.0, (double)2.7399700000000013), Block.box((double)7.242089999999999, (double)1.5, (double)0.7399700000000013, (double)8.74209, (double)2.5, (double)1.7399700000000013), Block.box((double)7.242089999999999, (double)11.0, (double)0.7399700000000013, (double)8.74209, (double)12.0, (double)1.7399700000000013), Block.box((double)7.242089999999999, (double)0.5, (double)0.7399700000000013, (double)8.74209, (double)1.5, (double)2.7399700000000013), Block.box((double)7.568429999999999, (double)0.5, (double)7.071790000000002, (double)8.56843, (double)13.0, (double)9.071790000000002), Block.box((double)7.341939999999999, (double)0.5, (double)13.383750000000001, (double)8.84194, (double)1.5, (double)15.383750000000001), Block.box((double)7.341939999999999, (double)1.5, (double)14.383750000000001, (double)8.84194, (double)2.5, (double)15.383750000000001), Block.box((double)7.341939999999999, (double)11.0, (double)14.383750000000001, (double)8.84194, (double)12.0, (double)15.383750000000001), Block.box((double)7.341939999999999, (double)12.0, (double)13.383750000000001, (double)8.84194, (double)13.0, (double)15.383750000000001), Block.box((double)7.591939999999999, (double)0.75, (double)8.133750000000001, (double)8.59194, (double)12.75, (double)15.133750000000001), Block.box((double)7.318429999999999, (double)1.5, (double)7.821790000000002, (double)7.568429999999999, (double)12.0, (double)8.321790000000002)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public LevelingAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)HORIZONTAL_FACING);
        if (SHAPE != null && SHAPE_2 != null) {
            return direction.getAxis() == Direction.Axis.X ? SHAPE_2 : SHAPE;
        }
        return FALLBACK;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, level, pos, rand);
        for (int i = -2; i <= 2; ++i) {
            block1: for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j == -1) {
                    j = 2;
                }
                if (rand.nextInt(16) != 0) continue;
                for (int k = 0; k <= 1; ++k) {
                    BlockPos blockpos = pos.offset(i, k, j);
                    if (!(level.getBlockState(blockpos).getEnchantPowerBonus((LevelReader)level, blockpos) > 0.0f)) continue;
                    if (!level.isEmptyBlock(pos.offset(i / 2, 0, j / 2))) continue block1;
                    level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, (double)((float)i + rand.nextFloat()) - 0.5, (double)((float)k - rand.nextFloat() - 1.0f), (double)((float)j + rand.nextFloat()) - 0.5);
                }
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LevelingAltarBlockEntity(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LevelingAltarBlockEntity) {
            Component itextcomponent = ((Nameable)blockEntity).getDisplayName();
            return new SimpleMenuProvider((id, inventory, player) -> {
                int playerLevel = level.isClientSide ? 0 : SpelledAPI.getLevel((Player)((ServerPlayer)player));
                return new AltarMenu(id, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos), playerLevel);
            }, itextcomponent);
        }
        return null;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HORIZONTAL_FACING, WATERLOGGED});
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.empty();
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter p_54766_, BlockPos p_54767_, BlockState p_54768_, Fluid p_54769_) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor p_54770_, BlockPos p_54771_, BlockState p_54772_, FluidState p_54773_) {
        return false;
    }
}

