/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.attachment;

import com.mrbysco.spelled.api.capability.ISpellData;
import com.mrbysco.spelled.api.keywords.KeywordRegistry;
import java.util.Locale;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class SpellData
implements ISpellData {
    private int level = 0;
    private CompoundTag unlockedKeywords = this.getDefaultUnlocks();
    private int castCooldown = 0;

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public CompoundTag getUnlocked() {
        return this.unlockedKeywords;
    }

    @Override
    public void setUnlocked(CompoundTag nbt) {
        this.unlockedKeywords = nbt;
    }

    @Override
    public boolean knowsKeyword(String keyword) {
        return this.unlockedKeywords.contains(keyword);
    }

    @Override
    public void unlockKeyword(String keyword) {
        this.unlockedKeywords.putBoolean(keyword.toLowerCase(Locale.ROOT), true);
    }

    @Override
    public void lockKeyword(String keyword) {
        KeywordRegistry registry = KeywordRegistry.instance();
        if (!registry.getTypes().contains(keyword)) {
            this.unlockedKeywords.remove(keyword.toLowerCase(Locale.ROOT));
        }
    }

    @Override
    public int getCastCooldown() {
        return this.castCooldown;
    }

    @Override
    public void setCastCooldown(int cooldown) {
        this.castCooldown = cooldown;
    }

    @Override
    public void resetUnlocks() {
        this.unlockedKeywords = this.getDefaultUnlocks();
    }

    private CompoundTag getDefaultUnlocks() {
        KeywordRegistry registry = KeywordRegistry.instance();
        CompoundTag tag = new CompoundTag();
        registry.getTypes().forEach(type -> tag.putBoolean(type, true));
        return tag;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("CharacterLevel", this.getLevel());
        tag.put("CharacterUnlocks", (Tag)this.getUnlocked());
        tag.putInt("characterCooldown", this.getCastCooldown());
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        int level = tag.getInt("CharacterLevel");
        CompoundTag characterUnlocks = tag.getCompound("CharacterUnlocks");
        int castCooldown = tag.getInt("characterCooldown");
        this.setLevel(level);
        this.setUnlocked(characterUnlocks);
        this.setCastCooldown(castCooldown);
    }
}

