/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.api.keywords;

import com.google.common.collect.Maps;
import com.mrbysco.spelled.Spelled;
import com.mrbysco.spelled.api.keywords.IKeyword;
import com.mrbysco.spelled.registry.keyword.BreakingKeyword;
import com.mrbysco.spelled.registry.keyword.ColdKeyword;
import com.mrbysco.spelled.registry.keyword.ColorKeyword;
import com.mrbysco.spelled.registry.keyword.ExplodingKeyword;
import com.mrbysco.spelled.registry.keyword.FireKeyword;
import com.mrbysco.spelled.registry.keyword.HealingKeyword;
import com.mrbysco.spelled.registry.keyword.HurtingKeyword;
import com.mrbysco.spelled.registry.keyword.LiquidKeyword;
import com.mrbysco.spelled.registry.keyword.MatureKeyword;
import com.mrbysco.spelled.registry.keyword.PowerKeyword;
import com.mrbysco.spelled.registry.keyword.ProtectKeyword;
import com.mrbysco.spelled.registry.keyword.PushingKeyword;
import com.mrbysco.spelled.registry.keyword.SilkKeyword;
import com.mrbysco.spelled.registry.keyword.SizeKeyword;
import com.mrbysco.spelled.registry.keyword.SnowKeyword;
import com.mrbysco.spelled.registry.keyword.TypeKeyword;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;

public class KeywordRegistry {
    private final Random random = new Random();
    private final Map<String, IKeyword> keywordMap = Maps.newHashMap();
    private final List<String> adjectiveList = new ArrayList<String>();
    private final List<String> typeList = new ArrayList<String>();
    private static KeywordRegistry INSTANCE;

    public static KeywordRegistry instance() {
        if (INSTANCE == null) {
            INSTANCE = new KeywordRegistry();
        }
        return INSTANCE;
    }

    public void reloadKeywords() {
        this.keywordMap.clear();
        this.typeList.clear();
        this.adjectiveList.clear();
        this.initializeKeywords();
    }

    public void initializeKeywords() {
        Spelled.LOGGER.info("Initializing keywords");
        this.registerKeyword(new ColorKeyword("ater", ChatFormatting.BLACK, 1, 1));
        this.registerKeyword(new ColorKeyword("aureus", ChatFormatting.GOLD, 1, 1));
        this.registerKeyword(new ColorKeyword("caeruleus", ChatFormatting.BLUE, 1, 1));
        this.registerKeyword(new ColorKeyword("viridis", ChatFormatting.GREEN, 1, 1));
        this.registerKeyword(new ColorKeyword("aqua", ChatFormatting.AQUA, 1, 1));
        this.registerKeyword(new ColorKeyword("rubrum", ChatFormatting.RED, 1, 1));
        this.registerKeyword(new ColorKeyword("roseus", ChatFormatting.LIGHT_PURPLE, 1, 1));
        this.registerKeyword(new ColorKeyword("flavus", ChatFormatting.YELLOW, 1, 1));
        this.registerKeyword(new ColorKeyword("albus", ChatFormatting.WHITE, 1, 1));
        this.registerKeyword(new SizeKeyword("parvus", 0.5f, 1, 1));
        this.registerKeyword(new SizeKeyword("magnum", 2.0f, 1, 2));
        this.registerKeyword(new SizeKeyword("grandis", 2.2f, 1, 2));
        this.registerKeyword(new SizeKeyword("immanis", 2.5f, 1, 3));
        this.registerKeyword(new LiquidKeyword("liquidus", 1, 1));
        this.registerKeyword(new SnowKeyword("nix", 1, 2));
        this.registerKeyword(new ColdKeyword("frigus", 1, 2));
        this.registerKeyword(new ExplodingKeyword("dissiliunt", 3, 2));
        this.registerKeyword(new HealingKeyword("sanitatem", 3, 2));
        this.registerKeyword(new HurtingKeyword("nocere", 1, 2));
        this.registerKeyword(new ProtectKeyword("praesidium", 1, 2));
        this.registerKeyword(new BreakingKeyword("fractionis", 1, 2));
        this.registerKeyword(new PushingKeyword("propellentibus", 1, 2));
        this.registerKeyword(new FireKeyword("ignis", 3, 2));
        this.registerKeyword(new PowerKeyword("vis", 1, 1));
        this.registerKeyword(new SilkKeyword("sericum", 3, 2));
        this.registerKeyword(new MatureKeyword("maturis", 2, 1));
        this.registerKeyword(new TypeKeyword("sphaera", TypeKeyword.Type.BALL, 2, 2));
        this.registerKeyword(new TypeKeyword("projectilis", TypeKeyword.Type.PROJECTILE, 2, 2));
        this.registerKeyword(new TypeKeyword("sui", TypeKeyword.Type.SELF, 1, 1));
        this.registerKeyword(new TypeKeyword("sese", TypeKeyword.Type.SELF, 1, 1));
    }

    public void registerKeyword(IKeyword behavior) {
        String keyword = behavior.getKeyword().toLowerCase(Locale.ROOT);
        if (!this.containsKey(keyword)) {
            this.keywordMap.put(keyword, behavior);
            if (behavior instanceof TypeKeyword) {
                if (!this.typeList.contains(keyword)) {
                    this.typeList.add(keyword);
                }
            } else if (!this.adjectiveList.contains(keyword)) {
                this.adjectiveList.add(keyword);
            }
        }
    }

    public boolean containsKey(String keyword) {
        if (!this.keywordMap.isEmpty()) {
            return this.keywordMap.containsKey(keyword.toLowerCase(Locale.ROOT));
        }
        return false;
    }

    public HashMap<String, IKeyword> getKeywords() {
        return new HashMap<String, IKeyword>(this.keywordMap);
    }

    public String getRandomAdjective() {
        if (!this.adjectiveList.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>(this.adjectiveList);
            return list.get(this.random.nextInt(list.size()));
        }
        return "";
    }

    public ArrayList<String> getTypes() {
        return new ArrayList<String>(this.typeList);
    }

    public ArrayList<String> getAdjectives() {
        return new ArrayList<String>(this.adjectiveList);
    }

    public List<String> getColors() {
        String[] colors = new String[]{"ater", "aureus", "caeruleus", "viridis", "aqua", "rubrum", "roseus", "flavus", "albus"};
        return Arrays.asList(colors);
    }

    public boolean isColor(String adjective) {
        return this.getColors().contains(adjective);
    }

    @Nullable
    public IKeyword getKeywordFromName(String keywordName) {
        String name = keywordName.toLowerCase(Locale.ROOT);
        if (this.containsKey(name)) {
            return this.keywordMap.get(name);
        }
        return null;
    }
}

