/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spelled.api.behavior;

import com.google.common.collect.Maps;
import com.mrbysco.spelled.Spelled;
import com.mrbysco.spelled.api.behavior.ISpellBehavior;
import com.mrbysco.spelled.registry.behavior.ColdBehavior;
import com.mrbysco.spelled.registry.behavior.ExplodeBehavior;
import com.mrbysco.spelled.registry.behavior.ExtinguishBehavior;
import com.mrbysco.spelled.registry.behavior.FireBehavior;
import com.mrbysco.spelled.registry.behavior.GlowBehavior;
import com.mrbysco.spelled.registry.behavior.HarvestBehavior;
import com.mrbysco.spelled.registry.behavior.HealBehavior;
import com.mrbysco.spelled.registry.behavior.HurtBehavior;
import com.mrbysco.spelled.registry.behavior.InkBehavior;
import com.mrbysco.spelled.registry.behavior.KnockbackBehavior;
import com.mrbysco.spelled.registry.behavior.LavaBehavior;
import com.mrbysco.spelled.registry.behavior.MatureBehavior;
import com.mrbysco.spelled.registry.behavior.ProtectBehavior;
import com.mrbysco.spelled.registry.behavior.SmokeBehavior;
import com.mrbysco.spelled.registry.behavior.SnowBehavior;
import com.mrbysco.spelled.registry.behavior.WaterBehavior;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public class BehaviorRegistry {
    private final Map<String, ISpellBehavior> behaviorMap = Maps.newHashMap();
    private static BehaviorRegistry INSTANCE;

    public static BehaviorRegistry instance() {
        if (INSTANCE == null) {
            INSTANCE = new BehaviorRegistry();
        }
        return INSTANCE;
    }

    public void reloadBehaviors() {
        this.behaviorMap.clear();
        this.initializeBehaviors();
    }

    public void initializeBehaviors() {
        Spelled.LOGGER.info("Initializing spell behavior");
        this.registerBehavior(new ColdBehavior());
        this.registerBehavior(new FireBehavior());
        this.registerBehavior(new ExplodeBehavior());
        this.registerBehavior(new HarvestBehavior());
        this.registerBehavior(new HealBehavior());
        this.registerBehavior(new HurtBehavior());
        this.registerBehavior(new ProtectBehavior());
        this.registerBehavior(new InkBehavior());
        this.registerBehavior(new GlowBehavior());
        this.registerBehavior(new KnockbackBehavior());
        this.registerBehavior(new LavaBehavior());
        this.registerBehavior(new SmokeBehavior());
        this.registerBehavior(new SnowBehavior());
        this.registerBehavior(new WaterBehavior());
        this.registerBehavior(new ExtinguishBehavior());
        this.registerBehavior(new MatureBehavior());
    }

    public void registerBehavior(ISpellBehavior behavior) {
        String keyword = behavior.getName().toLowerCase(Locale.ROOT);
        if (!this.containsKey(keyword)) {
            this.behaviorMap.put(keyword, behavior);
        }
    }

    public boolean containsKey(String keyword) {
        if (!this.behaviorMap.isEmpty()) {
            return this.behaviorMap.containsKey(keyword.toLowerCase(Locale.ROOT));
        }
        return false;
    }

    public HashMap<String, ISpellBehavior> getBehaviors() {
        return new HashMap<String, ISpellBehavior>(this.behaviorMap);
    }

    @Nullable
    public ISpellBehavior getBehaviorByName(String behavior) {
        String name = behavior.toLowerCase(Locale.ROOT);
        if (this.containsKey(name)) {
            return this.behaviorMap.get(name);
        }
        return null;
    }
}

