/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.utils;

import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SummonCheckHelper {
    public static boolean hasActiveSummons(Player player, double range, Set<Class<? extends IMagicSummon>> summonRegistry) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel level2 = (ServerLevel)level;
        List summons = level2.getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(range), entity -> {
            IMagicSummon magicSummon;
            return SummonCheckHelper.isRegisteredSummon(entity, summonRegistry) && entity instanceof IMagicSummon && (magicSummon = (IMagicSummon)entity).getSummoner() != null && magicSummon.getSummoner().getUUID().equals(player.getUUID());
        });
        return !summons.isEmpty();
    }

    private static boolean isRegisteredSummon(LivingEntity entity, Set<Class<? extends IMagicSummon>> summonRegistry) {
        for (Class<? extends IMagicSummon> summonClass : summonRegistry) {
            if (!summonClass.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return false;
    }
}

