/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.misc.MysteriousCubeBlockEntity;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.server.services.compass.ServerCompassService;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class MysteriousCubeBlock
extends AEBaseEntityBlock<MysteriousCubeBlockEntity> {
    public static final BlockBehaviour.Properties PROPERTIES = MysteriousCubeBlock.metalProps().strength(10.0f, 1000.0f).isRedstoneConductor(Blocks::never);

    public MysteriousCubeBlock() {
        super(PROPERTIES);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerCompassService.notifyBlockChange(serverLevel, pos);
        }
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.getBlock() == state.getBlock()) {
            return;
        }
        super.onRemove(state, level, pos, newState, isMoving);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerCompassService.notifyBlockChange(serverLevel, pos);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Tooltips.of(GuiText.MysteriousQuote, Tooltips.QUOTE_TEXT, new Object[0]));
    }
}

