/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.waila;

import de.teamlapen.vampirism.api.util.VResourceLocation;
import mcp.mobius.waila.api.ITooltipComponent;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BloodComponent
implements ITooltipComponent {
    public static final ResourceLocation BACKGROUND = VResourceLocation.mod((String)"blood_bar/background");
    public static final ResourceLocation HALF = VResourceLocation.mod((String)"blood_bar/half");
    public static final ResourceLocation QUARTER = VResourceLocation.mod((String)"blood_bar/quarter");
    public static final ResourceLocation HALF_TEXTURE_PATH = VResourceLocation.mod((String)"textures/gui/sprites/blood_bar/half.png");
    private final int blood;
    private final int iconCount;
    private final int lineWidth;

    public BloodComponent(int blood, int maxBlood, int maxPerLine) {
        this.blood = blood;
        this.iconCount = Mth.positiveCeilDiv((int)Mth.ceil((float)Math.max(blood, maxBlood)), (int)2);
        this.lineWidth = Math.min(this.iconCount, maxPerLine);
    }

    public int getWidth() {
        return this.lineWidth * 9 + 1;
    }

    public int getHeight() {
        return Mth.positiveCeilDiv((int)this.iconCount, (int)this.lineWidth) * 3 + 6;
    }

    public void render(GuiGraphics ctx, int x, int y, DeltaTracker delta) {
        int filled = this.blood / 2 - 1;
        int half = filled + this.blood % 2;
        for (int i = this.iconCount - 1; i >= 0; --i) {
            int ix = x + i % this.lineWidth * 8;
            int iy = y + i / this.lineWidth * 3;
            ctx.blitSprite(BACKGROUND, ix, iy, 9, 9);
            if (i <= filled) {
                ctx.blitSprite(HALF, ix, iy, 9, 9);
                continue;
            }
            if (i != half) continue;
            ctx.blitSprite(QUARTER, ix, iy, 9, 9);
        }
    }
}

