/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.jade.provider;

import de.teamlapen.vampirism.api.items.IBloodChargeable;
import de.teamlapen.vampirism.blockentity.PedestalBlockEntity;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.items.component.BloodCharged;
import de.teamlapen.vampirism_integrations.jade.JadePlugin;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;

public enum PedestalProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        if (blockAccessor.getServerData().contains("charge", 5)) {
            float charge = blockAccessor.getServerData().getFloat("charge");
            IElementHelper style = IElementHelper.get();
            iTooltip.add(style.progress(charge, null, style.progressStyle().color(6620696).textColor(-16711936), (BoxStyle)BoxStyle.GradientBorder.DEFAULT_NESTED_BOX, false));
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        PedestalBlockEntity pedestal;
        ItemStack stackForRender;
        Item item;
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof PedestalBlockEntity && (item = (stackForRender = (pedestal = (PedestalBlockEntity)blockEntity).getStackForRender()).getItem()) instanceof IBloodChargeable) {
            IBloodChargeable chargeable = (IBloodChargeable)item;
            BloodCharged changed = (BloodCharged)stackForRender.get((Supplier)ModDataComponents.BLOOD_CHARGED);
            compoundTag.putFloat("charge", changed != null ? changed.charged() : 0.0f);
        }
    }

    public ResourceLocation getUid() {
        return JadePlugin.PEDESTAL_CHARGING;
    }
}

