/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.guardvillagers.tasks;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.util.TotemHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import tallestegg.guardvillagers.common.entities.Guard;

public class GuardTargetNonFactionGoal
extends NearestAttackableTargetGoal<LivingEntity> {
    private static final Map<IFaction<?>, Predicate<LivingEntity>> predicates = new HashMap();
    private final Guard guard;
    private IFaction<?> faction;

    public GuardTargetNonFactionGoal(Guard guard) {
        super((Mob)guard, LivingEntity.class, true);
        this.guard = guard;
    }

    public boolean canContinueToUse() {
        if (this.guard.tickCount % 16 == 0 && this.determineGolemFaction()) {
            return false;
        }
        return super.canContinueToUse();
    }

    public boolean canUse() {
        if (this.guard.tickCount < 20) {
            return false;
        }
        return super.canUse();
    }

    protected void findTarget() {
        this.determineGolemFaction();
        super.findTarget();
    }

    private boolean determineGolemFaction() {
        IPlayableFaction faction = VReference.HUNTER_FACTION;
        if (((Boolean)VampirismConfig.BALANCE.golemAttackNonVillageFaction.get()).booleanValue()) {
            Optional tile = TotemHelper.getTotemNearPos((ServerLevel)((ServerLevel)this.guard.level()), (BlockPos)this.guard.blockPosition(), (boolean)true);
            faction = tile.map(TotemBlockEntity::getControllingFaction).orElse((IFaction)VReference.HUNTER_FACTION);
        }
        if (faction != this.faction) {
            this.faction = faction;
            this.targetConditions.selector(predicates.computeIfAbsent((IFaction<?>)this.faction, (Function<IFaction<?>, Predicate<LivingEntity>>)((Function<IFaction, Predicate>)faction1 -> VampirismAPI.factionRegistry().getPredicate(faction1, true, true, false, false, null))));
            return true;
        }
        return false;
    }
}

