/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.common.impl.item;

import com.ultramega.botanypotstiers.common.impl.BotanyPotsTiersMod;
import com.ultramega.botanypotstiers.common.impl.PotTier;
import com.ultramega.botanypotstiers.common.impl.block.TieredBotanyPotBlock;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class UpgradeItem
extends Item {
    private final PotTier tier;

    public UpgradeItem(Item.Properties properties, PotTier tier) {
        super(properties);
        this.tier = tier;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity newBlockEntity;
        String baseName;
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        Block block = state.getBlock();
        if (!(block instanceof BotanyPotBlock)) {
            return InteractionResult.FAIL;
        }
        BotanyPotBlock botanyPotBlock = (BotanyPotBlock)block;
        PotTier targetTier = PotTier.ELITE;
        if (block instanceof TieredBotanyPotBlock) {
            TieredBotanyPotBlock tieredPot = (TieredBotanyPotBlock)block;
            PotTier nextTier = PotTier.getNext(tieredPot.getTier());
            if (nextTier == null || nextTier != this.tier) {
                return InteractionResult.FAIL;
            }
            targetTier = nextTier;
            baseName = BuiltInRegistries.BLOCK.getKey((Object)botanyPotBlock).getPath().replaceFirst(tieredPot.getTier().getName() + "_", "");
        } else {
            if (this.tier != PotTier.ELITE) {
                return InteractionResult.FAIL;
            }
            baseName = BuiltInRegistries.BLOCK.getKey((Object)botanyPotBlock).getPath();
        }
        ResourceLocation newBlockId = BotanyPotsTiersMod.id(targetTier.getName() + "_" + baseName);
        Block newBlock = (Block)BuiltInRegistries.BLOCK.get(newBlockId);
        BlockEntity oldBlockEntity = level.getBlockEntity(pos);
        CompoundTag savedData = null;
        if (oldBlockEntity != null) {
            savedData = oldBlockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
            if (oldBlockEntity instanceof Container) {
                Container container = (Container)oldBlockEntity;
                for (int i = 0; i < container.getContainerSize(); ++i) {
                    container.setItem(i, ItemStack.EMPTY);
                }
            }
        }
        level.setBlock(pos, newBlock.defaultBlockState(), 3);
        if (savedData != null && (newBlockEntity = level.getBlockEntity(pos)) != null) {
            newBlockEntity.loadWithComponents(savedData, (HolderLookup.Provider)level.registryAccess());
        }
        context.getItemInHand().shrink(1);
        return InteractionResult.SUCCESS;
    }
}

