/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.common.impl.block.entity;

import com.ultramega.botanypotstiers.common.impl.BotanyPotsTiersMod;
import com.ultramega.botanypotstiers.common.impl.PotTier;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TieredBotanyPotBlockEntity
extends BotanyPotBlockEntity {
    private final PotTier tier;
    private int bonemealCooldown = 0;

    public TieredBotanyPotBlockEntity(BlockPos pos, BlockState state, PotTier tier) {
        super(TieredBotanyPotBlockEntity.getType(tier), pos, state);
        this.tier = tier;
    }

    public static void tickPot(Level level, BlockPos pos, BlockState state, TieredBotanyPotBlockEntity pot) {
        BotanyPotBlockEntity.tickPot((Level)level, (BlockPos)pos, (BlockState)state, (BotanyPotBlockEntity)pot);
    }

    public void reset() {
        super.reset();
        this.bonemealCooldown = 0;
    }

    public boolean canBonemeal() {
        return this.bonemealCooldown <= 0;
    }

    public void setBonemealCooldown(int cooldown) {
        this.bonemealCooldown = cooldown;
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.bonemealCooldown = tag.getInt("bonemeal_cooldown");
    }

    public void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("bonemeal_cooldown", this.bonemealCooldown);
    }

    public static CachedSupplier<BlockEntityType<BotanyPotBlockEntity>> getType(PotTier tier) {
        return CachedSupplier.of((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (ResourceLocation)BotanyPotsTiersMod.id(tier.getName() + "_botany_pot")).cast();
    }
}

