/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.botanypotstiers.common.impl;

import com.mojang.serialization.MapCodec;
import com.ultramega.botanypotstiers.common.impl.BotanyPotsTiersMod;
import com.ultramega.botanypotstiers.common.impl.PotTier;
import com.ultramega.botanypotstiers.common.impl.block.TieredBotanyPotBlock;
import com.ultramega.botanypotstiers.common.impl.block.entity.TieredBotanyPotBlockEntity;
import com.ultramega.botanypotstiers.common.impl.data.TieredBotanyPotFileGenerator;
import com.ultramega.botanypotstiers.common.impl.data.conditions.ConfigLoadCondition;
import com.ultramega.botanypotstiers.common.impl.item.UpgradeItem;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.registry.IContentProvider;
import net.darkhax.bookshelf.common.api.registry.register.MenuRegister;
import net.darkhax.bookshelf.common.api.registry.register.Register;
import net.darkhax.bookshelf.common.api.registry.register.RegisterBlockEntityRenderer;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItem;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItemTab;
import net.darkhax.bookshelf.common.api.registry.register.RegisterMenuScreen;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.botanypots.common.impl.block.BotanyPotRenderer;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class BotanyPotsTiersContent
implements IContentProvider {
    public static final Supplier<ItemStack> TAB_ICON = CachedSupplier.cache(() -> ((Item)BuiltInRegistries.ITEM.get(BotanyPotsTiersMod.id("elite_terracotta_botany_pot"))).getDefaultInstance());
    private static final String[] BRICK_TYPES = new String[]{"brick", "stone", "mossy_stone", "deepslate", "tuff", "mud", "prismarine", "nether", "red_nether", "polished_blackstone", "end_stone", "quartz"};
    private final Map<ResourceLocation, TieredBotanyPotBlock> allPotBlocks = new LinkedHashMap<ResourceLocation, TieredBotanyPotBlock>();
    private final Map<ResourceLocation, Item> allUpgradeItems = new LinkedHashMap<ResourceLocation, Item>();

    private void generatePotFiles() {
        TieredBotanyPotFileGenerator gen = new TieredBotanyPotFileGenerator(new File("outdir"), "botanypotstiers");
        this.make(gen, "terracotta");
        for (DyeColor dyeColor : DyeColor.values()) {
            this.make(gen, dyeColor.getName() + "_terracotta");
            this.make(gen, dyeColor.getName() + "_glazed_terracotta");
            this.make(gen, dyeColor.getName() + "_concrete");
        }
        for (String string : BRICK_TYPES) {
            this.make(gen, (String)("brick".equals(string) ? "bricks" : string + "_bricks"));
        }
    }

    private void make(TieredBotanyPotFileGenerator gen, String block) {
        ResourceLocation blockId = ResourceLocation.withDefaultNamespace((String)block);
        for (PotTier tier : PotTier.values()) {
            gen.potRecipes(blockId, tier);
            gen.models(blockId, tier);
            gen.lootTables(blockId, tier);
        }
    }

    public void registerBlocks(Register<Block> registry) {
        for (PotTier tier : PotTier.values()) {
            this.createPots(registry, "terracotta", tier);
            for (DyeColor dyeColor : DyeColor.values()) {
                this.createPots(registry, dyeColor.getName() + "_terracotta", tier);
                this.createPots(registry, dyeColor.getName() + "_glazed_terracotta", tier);
                this.createPots(registry, dyeColor.getName() + "_concrete", tier);
            }
            for (String string : BRICK_TYPES) {
                this.createPots(registry, (String)("brick".equals(string) ? "bricks" : string + "_bricks"), tier);
            }
        }
    }

    private void createPots(Register<Block> registry, String name, PotTier tier) {
        ResourceLocation blockId = ResourceLocation.withDefaultNamespace((String)name);
        MapColor color = BuiltInRegistries.BLOCK.containsKey(blockId) ? ((Block)BuiltInRegistries.BLOCK.get(blockId)).defaultMapColor() : MapColor.COLOR_ORANGE;
        this.registerPot(registry, tier.getName() + "_" + name + "_botany_pot", new TieredBotanyPotBlock(color, PotType.BASIC, tier));
        this.registerPot(registry, tier.getName() + "_" + name + "_hopper_botany_pot", new TieredBotanyPotBlock(color, PotType.HOPPER, tier));
        this.registerPot(registry, tier.getName() + "_" + name + "_waxed_botany_pot", new TieredBotanyPotBlock(color, PotType.WAXED, tier));
    }

    private void registerPot(Register<Block> registry, String id, TieredBotanyPotBlock block) {
        ResourceLocation blockId = ResourceLocation.fromNamespaceAndPath((String)this.contentNamespace(), (String)id);
        registry.add(blockId, (Object)block);
        this.allPotBlocks.put(blockId, block);
    }

    public void registerItems(RegisterItem registry) {
        for (Map.Entry<ResourceLocation, TieredBotanyPotBlock> block : this.allPotBlocks.entrySet()) {
            registry.addBlock((Block)block.getValue());
        }
        for (PotTier tier : PotTier.values()) {
            ResourceLocation itemId = BotanyPotsTiersMod.id(tier.getName() + "_upgrade");
            UpgradeItem item = new UpgradeItem(new Item.Properties().stacksTo(1), tier);
            registry.add(itemId, (Item)item);
            this.allUpgradeItems.put(itemId, item);
        }
    }

    public void registerBlockEntities(Register<BlockEntityType.Builder<?>> registry) {
        for (PotTier tier : PotTier.values()) {
            registry.add(tier.getName() + "_botany_pot", (Object)Services.GAMEPLAY.blockEntityBuilder((pos, state) -> new TieredBotanyPotBlockEntity((BlockPos)pos, (BlockState)state, tier), (Block[])this.allPotBlocks.values().stream().filter(block -> block.getTier() == tier).toArray(Block[]::new)));
        }
    }

    public void registerMenus(MenuRegister registry) {
    }

    public void registerLoadConditions(Register<MapCodec<? extends ILoadCondition>> registry) {
        registry.add(ConfigLoadCondition.TYPE_ID, ConfigLoadCondition.CODEC);
    }

    public void registerItemTabs(RegisterItemTab registry) {
        registry.add("tab", TAB_ICON, (params, builder) -> {
            for (Item item : this.allUpgradeItems.values()) {
                builder.accept((ItemLike)item);
            }
            for (Block block : this.allPotBlocks.values()) {
                builder.accept((ItemLike)block.asItem());
            }
        });
    }

    public void bindBlockEntityRenderer(RegisterBlockEntityRenderer registry) {
        for (PotTier tier : PotTier.values()) {
            registry.bind((BlockEntityType)TieredBotanyPotBlockEntity.getType(tier).get(), BotanyPotRenderer::new);
        }
    }

    public void registerMenuScreens(RegisterMenuScreen registry) {
    }

    public void bindRenderLayers(BiConsumer<Block, RenderType> registry) {
        for (Block block : this.allPotBlocks.values()) {
            registry.accept(block, RenderType.cutout());
        }
    }

    public String contentNamespace() {
        return "botanypotstiers";
    }
}

