/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.registry;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.DoNotCall;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryClass;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryCollector;
import net.valhelsia.valhelsia_core.api.common.registry.helper.MappedRegistryHelper;
import net.valhelsia.valhelsia_core.api.common.registry.helper.RegistryHelper;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryHelper;
import net.valhelsia.valhelsia_core.api.common.registry.helper.datapack.DatapackRegistryHelper;
import net.valhelsia.valhelsia_core.api.common.registry.helper.item.ItemRegistryHelper;

public record RegistryManager(String modId, ImmutableMap<ResourceKey<? extends Registry<?>>, RegistryHelper<?, ? extends RegistryClass>> registryHelpers) {
    public RegistryManager(RegistryCollector collector) {
        this(collector.getModId(), collector.getHelpers());
    }

    public static RegistryManager constructEmpty(String modId) {
        return new RegistryManager(modId, ImmutableMap.of());
    }

    public <T> boolean hasHelper(ResourceKey<Registry<T>> registryResourceKey) {
        return this.registryHelpers.containsKey(registryResourceKey);
    }

    public <T, H extends RegistryHelper<T, ?>> H getHelper(ResourceKey<Registry<T>> registryResourceKey) {
        if (!this.hasHelper(registryResourceKey)) {
            throw new NullPointerException("Registry Manager for '" + this.modId() + "' has no Helper for registry: " + String.valueOf(registryResourceKey.location()));
        }
        return (H)((RegistryHelper)this.registryHelpers.get(registryResourceKey));
    }

    public BlockRegistryHelper getBlockHelper() {
        return (BlockRegistryHelper)this.getHelper(Registries.BLOCK);
    }

    public ItemRegistryHelper getItemHelper() {
        return (ItemRegistryHelper)this.getHelper(Registries.ITEM);
    }

    @DoNotCall
    public void register() {
        for (RegistryHelper registryHelper : this.registryHelpers.values()) {
            if (!(registryHelper instanceof MappedRegistryHelper)) continue;
            MappedRegistryHelper mappedRegistryHelper = (MappedRegistryHelper)registryHelper;
            registryHelper.getRegistryClasses().forEach(registryClass -> {
                try {
                    Class.forName(registryClass.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
            mappedRegistryHelper.internalRegister();
        }
        if (this.hasHelper(Registries.ITEM) && this.hasHelper(Registries.BLOCK)) {
            this.getItemHelper().registerBlockItems(this.getBlockHelper());
        }
    }

    public RegistrySetBuilder buildRegistrySet() {
        RegistrySetBuilder builder = new RegistrySetBuilder();
        for (RegistryHelper helper : this.registryHelpers.values()) {
            if (!(helper instanceof DatapackRegistryHelper)) continue;
            DatapackRegistryHelper datapackRegistryHelper = (DatapackRegistryHelper)helper;
            Function<BootstrapContext, List> function = context -> datapackRegistryHelper.getClassCollector().collect((BootstrapContext<?>)context);
            builder.add(datapackRegistryHelper.getRegistry(), function::apply);
        }
        return builder;
    }
}

