/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.xkmc.l2complements.events.SpecialEquipmentEvents;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.LCDamageTypes;
import dev.xkmc.l2complements.init.data.LCTagGen;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2core.events.SchedulerHandler;
import dev.xkmc.l2core.util.ServerProxy;
import dev.xkmc.l2serial.util.Wrappers;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.extensions.IItemStackExtension;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements IItemStackExtension {
    @Shadow
    public abstract boolean is(TagKey<Item> var1);

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;setDamageValue(I)V")}, method={"hurtAndBreak(ILnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V"})
    public void l2complements_hurt_safeguard_setDamage(ItemStack self, int val, Operation<Void> op, @Local(argsOnly=true) LivingEntity user) {
        Optional opt;
        int max;
        if (this.getEnchantmentLevel(LCEnchantments.ETERNAL.holder()) > 0) {
            return;
        }
        if (user != null && this.getEnchantmentLevel(LCEnchantments.LIFE_SYNC.holder()) > 0) {
            float dmg = (float)((double)val * (Double)LCConfig.SERVER.lifeSyncFactor.get());
            SchedulerHandler.schedule(() -> user.hurt(new DamageSource(LCDamageTypes.forKey(user.level(), LCDamageTypes.LIFE_SYNC)), dmg));
            return;
        }
        if (!SpecialEquipmentEvents.PLAYER.get().isEmpty()) {
            BlockState state = (BlockState)SpecialEquipmentEvents.PLAYER.get().peek().getSecond();
            if (this.getEnchantmentLevel(LCEnchantments.TREE.holder()) >= 2 && state.is(LCTagGen.AS_LEAF)) {
                return;
            }
        }
        if ((max = self.getMaxDamage()) <= val + 1 && self.getEnchantmentLevel(LCEnchantments.SAFEGUARD.holder()) > 0 && (opt = ServerProxy.getServer()).isPresent()) {
            int old = self.getDamageValue();
            long time = (Long)LCItems.SAFEGUARD_TIME.getOrDefault(self, (Object)0L);
            long current = ((MinecraftServer)opt.orElseThrow()).overworld().getGameTime();
            if (max <= val) {
                if (current == time) {
                    val = old;
                } else if (max > old + 1) {
                    val = max - 1;
                    LCItems.SAFEGUARD_TIME.set(self, (Object)current);
                }
            } else if (max == val + 1) {
                LCItems.SAFEGUARD_TIME.set(self, (Object)current);
            }
        }
        op.call(new Object[]{self, val});
    }

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"getMaxDamage"})
    public int l2complements_getMaxDamage_durabilityEnchantment(int max) {
        if (!this.is((TagKey<Item>)ItemTags.ARMOR_ENCHANTABLE)) {
            return max;
        }
        int lv = LCEnchantments.DURABLE_ARMOR.getLvIntrinsic((ItemStack)Wrappers.cast((Object)this));
        return max * (1 + lv);
    }
}

