/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.extensions.IItemStackExtension;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IItemStackExtension.class})
public interface IItemStackExtensionMixin {
    @Shadow
    public int getEnchantmentLevel(Holder<Enchantment> var1);

    @Inject(at={@At(value="HEAD")}, method={"makesPiglinsNeutral"}, cancellable=true)
    default public void l2complements_makesPiglinsNeutral_enchantOverride(LivingEntity wearer, CallbackInfoReturnable<Boolean> cir) {
        if (this.getEnchantmentLevel((Holder<Enchantment>)LCEnchantments.SHINNY.holder()) > 0) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isPiglinCurrency"}, cancellable=true)
    default public void l2complements_isPiglinCurrency_enchantOverride(CallbackInfoReturnable<Boolean> cir) {
        if (this.getEnchantmentLevel((Holder<Enchantment>)LCEnchantments.SHINNY.holder()) > 0) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isEnderMask"}, cancellable=true)
    default public void l2complements_isEnderMask_enchantOverride(CallbackInfoReturnable<Boolean> cir) {
        if (this.getEnchantmentLevel((Holder<Enchantment>)LCEnchantments.ENDER_MASK.holder()) > 0) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canWalkOnPowderedSnow"}, cancellable=true)
    default public void l2complements_canWalkOnPowderedSnow_enchantOverride(CallbackInfoReturnable<Boolean> cir) {
        if (this.getEnchantmentLevel((Holder<Enchantment>)LCEnchantments.SNOW_WALKER.holder()) > 0) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"getSweepHitBox"}, remap=false)
    default public AABB l2complements_getSweepHitBox_enchantOverride(AABB box) {
        int lv = this.getEnchantmentLevel((Holder<Enchantment>)LCEnchantments.WIND_SWEEP.holder());
        if (lv > 0) {
            double amount = (Double)LCConfig.SERVER.windSweepIncrement.get();
            box = box.inflate(amount * (double)lv, amount * (double)lv, amount * (double)lv);
        }
        return box;
    }
}

