/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.init.registrate;

import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.l2complements.content.enchantment.core.EnchantmentInjector;
import dev.xkmc.l2complements.content.entity.fireball.BlackFireball;
import dev.xkmc.l2complements.content.entity.fireball.SoulFireball;
import dev.xkmc.l2complements.content.entity.fireball.StrongFireball;
import dev.xkmc.l2complements.content.item.create.RefinedRadianceItem;
import dev.xkmc.l2complements.content.item.create.VoidEyeItem;
import dev.xkmc.l2complements.content.item.misc.BurntItem;
import dev.xkmc.l2complements.content.item.misc.EternalTotem;
import dev.xkmc.l2complements.content.item.misc.FireChargeItem;
import dev.xkmc.l2complements.content.item.misc.HomeTotem;
import dev.xkmc.l2complements.content.item.misc.LCBEWLR;
import dev.xkmc.l2complements.content.item.misc.PoseiditeTotem;
import dev.xkmc.l2complements.content.item.misc.TooltipItem;
import dev.xkmc.l2complements.content.item.misc.TransformItem;
import dev.xkmc.l2complements.content.item.misc.WarpStone;
import dev.xkmc.l2complements.content.item.misc.WindBottle;
import dev.xkmc.l2complements.content.item.wand.DiffusionWand;
import dev.xkmc.l2complements.content.item.wand.HellfireWand;
import dev.xkmc.l2complements.content.item.wand.SonicShooter;
import dev.xkmc.l2complements.content.item.wand.WinterStormWand;
import dev.xkmc.l2complements.init.L2Complements;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.LCLang;
import dev.xkmc.l2complements.init.data.LCTagGen;
import dev.xkmc.l2complements.init.materials.LCMats;
import dev.xkmc.l2complements.init.registrate.LCBlocks;
import dev.xkmc.l2complements.init.registrate.LCEffects;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2core.init.reg.registrate.SimpleEntry;
import dev.xkmc.l2core.init.reg.simple.DCReg;
import dev.xkmc.l2core.init.reg.simple.DCVal;
import dev.xkmc.l2core.init.reg.simple.Reg;
import dev.xkmc.l2damagetracker.contents.materials.api.IMatVanillaType;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.Tags;

@MethodsReturnNonnullByDefault
public class LCItems {
    private static final DCReg DC = DCReg.of((Reg)L2Complements.REG);
    public static final SimpleEntry<CreativeModeTab> TAB_ITEM;
    public static final SimpleEntry<CreativeModeTab> TAB_ENCHMIN;
    public static final SimpleEntry<CreativeModeTab> TAB_ENCHMAX;
    public static final ItemEntry<TooltipItem> WIND_BOTTLE;
    public static final ItemEntry<TooltipItem> VOID_EYE;
    public static final ItemEntry<TooltipItem> SUN_MEMBRANE;
    public static final ItemEntry<TooltipItem> SOUL_FLAME;
    public static final ItemEntry<TooltipItem> CAPTURED_WIND;
    public static final ItemEntry<TooltipItem> CAPTURED_BULLET;
    public static final ItemEntry<TooltipItem> EXPLOSION_SHARD;
    public static final ItemEntry<TooltipItem> HARD_ICE;
    public static final ItemEntry<TooltipItem> STORM_CORE;
    public static final ItemEntry<TooltipItem> BLACKSTONE_CORE;
    public static final ItemEntry<TooltipItem> RESONANT_FEATHER;
    public static final ItemEntry<TooltipItem> SPACE_SHARD;
    public static final ItemEntry<TooltipItem> WARDEN_BONE_SHARD;
    public static final ItemEntry<TooltipItem> GUARDIAN_EYE;
    public static final ItemEntry<TransformItem> GUARDIAN_RUNE;
    public static final ItemEntry<TransformItem> PIGLIN_RUNE;
    public static final ItemEntry<BurntItem> EMERALD;
    public static final ItemEntry<BurntItem> CURSED_DROPLET;
    public static final ItemEntry<BurntItem> LIFE_ESSENCE;
    public static final ItemEntry<TooltipItem> FORCE_FIELD;
    public static final ItemEntry<WarpStone> FRAGILE_WARP_STONE;
    public static final ItemEntry<WarpStone> REINFORCED_WARP_STONE;
    public static final ItemEntry<HomeTotem> TOTEM_OF_DREAM;
    public static final ItemEntry<PoseiditeTotem> TOTEM_OF_THE_SEA;
    public static final ItemEntry<EternalTotem> ETERNAL_TOTEM;
    public static final ItemEntry<FireChargeItem<SoulFireball>> SOUL_CHARGE;
    public static final ItemEntry<FireChargeItem<StrongFireball>> STRONG_CHARGE;
    public static final ItemEntry<FireChargeItem<BlackFireball>> BLACK_CHARGE;
    public static final ItemEntry<SonicShooter> SONIC_SHOOTER;
    public static final ItemEntry<HellfireWand> HELLFIRE_WAND;
    public static final ItemEntry<WinterStormWand> WINTERSTORM_WAND;
    public static final ItemEntry<DiffusionWand> DIFFUSION_WAND;
    public static final ItemEntry<Item> TOTEMIC_CARROT;
    public static final ItemEntry<Item> TOTEMIC_APPLE;
    public static final ItemEntry<Item> ENCHANT_TOTEMIC_CARROT;
    public static final ItemEntry<Item> ENCHANTED_TOTEMIC_APPLE;
    public static final ItemEntry<Item>[] MAT_INGOTS;
    public static final ItemEntry<Item>[] MAT_NUGGETS;
    public static final ItemEntry<Item>[][] GEN_ITEM;
    public static final DCVal<String> DIGGER_SEL;
    public static final DCVal<Long> SAFEGUARD_TIME;
    public static final DCVal<Unit> IN_WATER;
    public static final DCVal<WarpStone.PosData> POS_DATA;

    public static MutableComponent getTooltip(MobEffectInstance eff) {
        MutableComponent comp = Component.translatable((String)eff.getDescriptionId());
        MobEffect mobeffect = (MobEffect)eff.getEffect().value();
        if (eff.getAmplifier() > 0) {
            comp = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{comp, Component.translatable((String)("potion.potency." + eff.getAmplifier()))});
        }
        if (eff.getDuration() > 20) {
            comp = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{comp, MobEffectUtil.formatDuration((MobEffectInstance)eff, (float)1.0f, (float)20.0f)});
        }
        return comp.withStyle(mobeffect.getCategory().getTooltipFormatting());
    }

    public static <T extends Item> ItemEntry<T> simpleItem(String id, String name, BiFunction<Item.Properties, Supplier<MutableComponent>, T> func, Rarity r, Supplier<MutableComponent> sup) {
        return L2Complements.REGISTRATE.item(id, p -> (Item)func.apply(p.fireResistant().rarity(r), sup)).defaultModel().tag(new TagKey[]{LCTagGen.SPECIAL_ITEM}).lang(name).register();
    }

    public static ItemEntry<TransformItem> transform(String id, String name, Supplier<EntityType<? extends Mob>> from, Supplier<EntityType<? extends Mob>> to) {
        return L2Complements.REGISTRATE.item(id, p -> new TransformItem(p.fireResistant().rarity(Rarity.RARE), from, to)).defaultModel().tag(new TagKey[]{LCTagGen.SPECIAL_ITEM}).lang(name).register();
    }

    public static void register() {
    }

    static {
        TAB_ENCHMIN = L2Complements.REGISTRATE.buildL2CreativeTab("enchantments_low", "L2's Enchantments - Craftable", b -> b.icon(() -> ((Item)Items.BOOK).getDefaultInstance()));
        TAB_ENCHMAX = L2Complements.REGISTRATE.buildL2CreativeTab("enchantments_max", "L2's Enchantments - Lv Max", b -> b.icon(() -> EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(LCEnchantments.SOUL_BOUND.holder(), 1))));
        TAB_ITEM = L2Complements.REGISTRATE.buildL2CreativeTab("l2complements", "L2Complements Items", b -> b.icon(() -> RESONANT_FEATHER.asStack()));
        LCBlocks.register();
        DIGGER_SEL = DC.str("selected_digger");
        SAFEGUARD_TIME = DC.longVal("safeguard_timestamp");
        IN_WATER = DC.unit("in_water");
        POS_DATA = DC.reg("pos_data", WarpStone.PosData.class, false);
        MAT_INGOTS = L2Complements.MATS.genMats((IMatVanillaType[])LCMats.values(), "ingot", Tags.Items.INGOTS);
        MAT_NUGGETS = L2Complements.MATS.genMats((IMatVanillaType[])LCMats.values(), "nugget", Tags.Items.NUGGETS);
        WIND_BOTTLE = LCItems.simpleItem("wind_capture_bottle", "Wind Capturing Bottle", WindBottle::new, Rarity.COMMON, LCLang.Items::windBottle);
        VOID_EYE = LCItems.simpleItem("void_eye", "Void Eye", VoidEyeItem::new, Rarity.EPIC, LCLang.Items::voidEye);
        CAPTURED_WIND = LCItems.simpleItem("captured_wind", "Essence of Wind", TooltipItem::new, Rarity.RARE, LCLang.Items::capturedWind);
        CAPTURED_BULLET = LCItems.simpleItem("captured_shulker_bullet", "Shulker Bullet in Bottle", TooltipItem::new, Rarity.UNCOMMON, LCLang.Items::capturedBullet);
        SUN_MEMBRANE = LCItems.simpleItem("sun_membrane", "Membrane of the Sun", RefinedRadianceItem::new, Rarity.EPIC, LCLang.Items::sunMembrane);
        EXPLOSION_SHARD = LCItems.simpleItem("explosion_shard", "Remnant Shard of Explosion", TooltipItem::new, Rarity.UNCOMMON, LCLang.Items::explosionShard);
        HARD_ICE = LCItems.simpleItem("hard_ice", "Unliving Ice", TooltipItem::new, Rarity.UNCOMMON, LCLang.Items::hardIce);
        SOUL_FLAME = LCItems.simpleItem("soul_flame", "Soul Flame", RefinedRadianceItem::new, Rarity.RARE, LCLang.Items::soulFlame);
        STORM_CORE = LCItems.simpleItem("storm_core", "Crystal of Storm", TooltipItem::new, Rarity.UNCOMMON, LCLang.Items::stormCore);
        BLACKSTONE_CORE = LCItems.simpleItem("blackstone_core", "Blackstone Core", TooltipItem::new, Rarity.RARE, LCLang.Items::blackstoneCore);
        RESONANT_FEATHER = LCItems.simpleItem("resonant_feather", "Resonant Feather", TooltipItem::new, Rarity.EPIC, LCLang.Items::resonantFeather);
        SPACE_SHARD = LCItems.simpleItem("space_shard", "Space Shard (Creative)", TooltipItem::new, Rarity.EPIC, LCLang.Items::spaceShard);
        WARDEN_BONE_SHARD = LCItems.simpleItem("warden_bone_shard", "Warden Bone Shard", TooltipItem::new, Rarity.RARE, LCLang.Items::wardenBoneShard);
        GUARDIAN_EYE = LCItems.simpleItem("guardian_eye", "Eye of Elder Guardian", TooltipItem::new, Rarity.RARE, LCLang.Items::guardianEye);
        EMERALD = L2Complements.REGISTRATE.item("heirophant_green", p -> new BurntItem(p.fireResistant().rarity(Rarity.EPIC))).defaultModel().tag(new TagKey[]{LCTagGen.SPECIAL_ITEM}).lang("Heirophant Green").register();
        CURSED_DROPLET = L2Complements.REGISTRATE.item("cursed_droplet", p -> new BurntItem(p.fireResistant().rarity(Rarity.RARE))).defaultModel().tag(new TagKey[]{LCTagGen.SPECIAL_ITEM}).lang("Cursed Droplet").register();
        LIFE_ESSENCE = L2Complements.REGISTRATE.item("life_essence", p -> new BurntItem(p.fireResistant().rarity(Rarity.RARE).food(new FoodProperties.Builder().nutrition(20).saturationModifier(1.2f).alwaysEdible().fast().build()))).defaultModel().tag(new TagKey[]{LCTagGen.SPECIAL_ITEM}).lang("Essence of Life").register();
        FORCE_FIELD = L2Complements.REGISTRATE.item("force_field", p -> new TooltipItem(p.fireResistant().rarity(Rarity.EPIC), LCLang.Items::forceField)).model((ctx, pvd) -> ((ItemModelBuilder)pvd.getBuilder(ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).lang("Wither Force Field").tag(new TagKey[]{LCTagGen.SPECIAL_ITEM}).clientExtension(() -> () -> LCBEWLR.EXTENSIONS).register();
        GUARDIAN_RUNE = LCItems.transform("guardian_rune", "Rune of Guardian", () -> EntityType.GUARDIAN, () -> EntityType.ELDER_GUARDIAN);
        PIGLIN_RUNE = LCItems.transform("piglin_rune", "Rune of Piglin", () -> EntityType.PIGLIN, () -> EntityType.PIGLIN_BRUTE);
        FRAGILE_WARP_STONE = L2Complements.REGISTRATE.item("fragile_warp_stone", p -> new WarpStone(p.fireResistant().stacksTo(1).rarity(Rarity.RARE), true)).defaultModel().defaultLang().register();
        REINFORCED_WARP_STONE = L2Complements.REGISTRATE.item("reinforced_warp_stone", p -> new WarpStone(p.fireResistant().stacksTo(1).durability(64).rarity(Rarity.RARE), false)).defaultModel().defaultLang().register();
        TagKey charm = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"charm"));
        TOTEM_OF_DREAM = L2Complements.REGISTRATE.item("totem_of_dream", p -> new HomeTotem(p.fireResistant().stacksTo(1).rarity(Rarity.EPIC))).tag(new TagKey[]{charm}).defaultModel().defaultLang().register();
        TOTEM_OF_THE_SEA = L2Complements.REGISTRATE.item("totem_of_the_sea", p -> new PoseiditeTotem(p.fireResistant().stacksTo(16).rarity(Rarity.EPIC))).tag(new TagKey[]{charm}).defaultModel().defaultLang().register();
        ETERNAL_TOTEM = L2Complements.REGISTRATE.item("eternal_totem_of_dream", p -> new EternalTotem(p.fireResistant().stacksTo(1).rarity(Rarity.EPIC))).tag(new TagKey[]{charm}).defaultModel().defaultLang().register();
        SOUL_CHARGE = L2Complements.REGISTRATE.item("soul_fire_charge", p -> new FireChargeItem<SoulFireball>((Item.Properties)p, SoulFireball::new, SoulFireball::new, () -> LCLang.IDS.EFFECT_CHARGE.get(LCItems.getTooltip(new MobEffectInstance(LCEffects.FLAME.holder(), ((Integer)LCConfig.SERVER.soulFireChargeDuration.get()).intValue()))))).defaultModel().defaultLang().register();
        STRONG_CHARGE = L2Complements.REGISTRATE.item("strong_fire_charge", p -> new FireChargeItem<StrongFireball>((Item.Properties)p, StrongFireball::new, StrongFireball::new, () -> LCLang.IDS.EXPLOSION_CHARGE.get(LCConfig.SERVER.strongFireChargePower.get()))).defaultModel().defaultLang().register();
        BLACK_CHARGE = L2Complements.REGISTRATE.item("black_fire_charge", p -> new FireChargeItem<BlackFireball>((Item.Properties)p, BlackFireball::new, BlackFireball::new, () -> LCLang.IDS.EFFECT_CHARGE.get(LCItems.getTooltip(new MobEffectInstance(LCEffects.INCARCERATE.holder(), ((Integer)LCConfig.SERVER.blackFireChargeDuration.get()).intValue()))))).defaultModel().defaultLang().register();
        SONIC_SHOOTER = L2Complements.REGISTRATE.item("sonic_shooter", p -> new SonicShooter(p.durability(64).fireResistant().rarity(Rarity.EPIC))).tag(new TagKey[]{ItemTags.DURABILITY_ENCHANTABLE}).model((ctx, pvd) -> {
            ModelFile.UncheckedModelFile parent = new ModelFile.UncheckedModelFile(pvd.modLoc("item/gun"));
            ItemModelBuilder base = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)pvd.getBuilder(ctx.getName())).parent((ModelFile)parent)).texture("layer0", "item/" + ctx.getName());
            ResourceLocation id = L2Complements.loc("shoot");
            for (int i = 0; i < 4; ++i) {
                String str = ctx.getName() + "_" + i;
                base.override().predicate(id, (float)i * 0.2f + 0.2f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)pvd.getBuilder(str)).parent((ModelFile)parent)).texture("layer0", "item/" + str)).end();
            }
        }).defaultLang().register();
        HELLFIRE_WAND = L2Complements.REGISTRATE.item("hellfire_wand", p -> new HellfireWand(p.durability(64).fireResistant().rarity(Rarity.EPIC))).tag(new TagKey[]{ItemTags.DURABILITY_ENCHANTABLE}).model((ctx, pvd) -> pvd.handheld((NonNullSupplier)ctx)).defaultLang().register();
        DIFFUSION_WAND = L2Complements.REGISTRATE.item("diffusion_wand", p -> new DiffusionWand(p.durability(8).fireResistant().rarity(Rarity.RARE))).model((ctx, pvd) -> pvd.handheld((NonNullSupplier)ctx)).defaultLang().register();
        WINTERSTORM_WAND = L2Complements.REGISTRATE.item("winterstorm_wand", p -> new WinterStormWand(p.durability(128).fireResistant().rarity(Rarity.RARE))).tag(new TagKey[]{ItemTags.DURABILITY_ENCHANTABLE}).model((ctx, pvd) -> pvd.handheld((NonNullSupplier)ctx)).defaultLang().register();
        TOTEMIC_CARROT = L2Complements.REGISTRATE.item("totemic_carrot", p -> new Item(p.food(new FoodProperties.Builder().nutrition(6).saturationModifier(1.2f).alwaysEdible().effect(() -> new MobEffectInstance(MobEffects.NIGHT_VISION, 1200), 1.0f).effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 1), 1.0f).build()))).defaultModel().defaultLang().register();
        ENCHANT_TOTEMIC_CARROT = L2Complements.REGISTRATE.item("enchanted_totemic_carrot", p -> new Item(p.food(new FoodProperties.Builder().nutrition(6).saturationModifier(1.2f).alwaysEdible().effect(() -> new MobEffectInstance(MobEffects.NIGHT_VISION, 3600), 1.0f).effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 3600, 2), 1.0f).effect(() -> new MobEffectInstance(MobEffects.DIG_SPEED, 3600, 1), 1.0f).effect(() -> new MobEffectInstance(MobEffects.SATURATION, 20), 1.0f).build()).component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true))).defaultModel().defaultLang().register();
        TOTEMIC_APPLE = L2Complements.REGISTRATE.item("totemic_apple", p -> new Item(p.food(new FoodProperties.Builder().nutrition(6).saturationModifier(1.2f).alwaysEdible().effect(() -> new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 2400), 1.0f).effect(() -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 2400, 1), 1.0f).effect(() -> new MobEffectInstance(MobEffects.ABSORPTION, 2400, 4), 1.0f).effect(() -> new MobEffectInstance(MobEffects.SATURATION, 60), 1.0f).build()))).defaultModel().defaultLang().register();
        ENCHANTED_TOTEMIC_APPLE = L2Complements.REGISTRATE.item("enchanted_totemic_apple", p -> new Item(p.food(new FoodProperties.Builder().nutrition(6).saturationModifier(1.2f).alwaysEdible().effect(() -> new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 2400), 1.0f).effect(() -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 2400, 3), 1.0f).effect(() -> new MobEffectInstance(MobEffects.ABSORPTION, 2400, 4), 1.0f).effect(() -> new MobEffectInstance(MobEffects.SATURATION, 100), 1.0f).build()).component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true))).defaultModel().defaultLang().register();
        GEN_ITEM = L2Complements.MATS.genItem((IMatVanillaType[])LCMats.values());
        EnchantmentInjector.injectTab(L2Complements.REGISTRATE);
    }
}

