/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.init.data;

import dev.xkmc.l2complements.init.L2Complements;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.l2damagetracker.init.data.DamageTypeAndTagsGen;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;

public class LCDamageTypes
extends DamageTypeAndTagsGen {
    public static final ResourceKey<DamageType> BLEED = LCDamageTypes.create("bleed", "%s bleed to death");
    public static final ResourceKey<DamageType> LIFE_SYNC = LCDamageTypes.create("life_sync", "%s was drained");
    public static final ResourceKey<DamageType> VOID_EYE = LCDamageTypes.create("void_eye", "%s was cursed by void eye");
    public static final ResourceKey<DamageType> EMERALD = LCDamageTypes.create("emerald", "%s was killed by emerald splash", "%s was killed by emerald splash from %s");
    public static final ResourceKey<DamageType> SOUL_FLAME = LCDamageTypes.create("soul_flame", "%s has its soul burnt out", "%s has its soul burnt out by %s");

    public LCDamageTypes(L2Registrate reg) {
        super(reg);
        new DamageTypeAndTagsGen.DamageTypeHolder((DamageTypeAndTagsGen)this, EMERALD, new DamageType("emerald", DamageScaling.NEVER, 0.1f)).add(new TagKey[]{DamageTypeTags.AVOIDS_GUARDIAN_THORNS});
        new DamageTypeAndTagsGen.DamageTypeHolder((DamageTypeAndTagsGen)this, SOUL_FLAME, new DamageType("soul_flame", DamageScaling.NEVER, 0.0f, DamageEffects.BURNING)).add(new TagKey[]{DamageTypeTags.BYPASSES_ARMOR, Tags.DamageTypes.IS_MAGIC, DamageTypeTags.AVOIDS_GUARDIAN_THORNS, L2DamageTypes.NO_SCALE, DamageTypeTags.NO_KNOCKBACK});
        new DamageTypeAndTagsGen.DamageTypeHolder((DamageTypeAndTagsGen)this, BLEED, new DamageType("bleed", DamageScaling.NEVER, 0.1f)).add(new TagKey[]{DamageTypeTags.BYPASSES_ARMOR, L2DamageTypes.NO_SCALE, DamageTypeTags.NO_KNOCKBACK}).add(L2DamageTypes.BYPASS_MAGIC);
        new DamageTypeAndTagsGen.DamageTypeHolder((DamageTypeAndTagsGen)this, LIFE_SYNC, new DamageType("life_sync", DamageScaling.NEVER, 0.0f)).add(new TagKey[]{DamageTypeTags.BYPASSES_ARMOR, L2DamageTypes.NO_SCALE, DamageTypeTags.NO_KNOCKBACK, DamageTypeTags.NO_IMPACT, DamageTypeTags.BYPASSES_COOLDOWN}).add(L2DamageTypes.BYPASS_MAGIC);
        new DamageTypeAndTagsGen.DamageTypeHolder((DamageTypeAndTagsGen)this, VOID_EYE, new DamageType("void_eye", DamageScaling.NEVER, 0.0f)).add(new TagKey[]{DamageTypeTags.NO_KNOCKBACK}).add(L2DamageTypes.BYPASS_INVUL);
    }

    public static Holder<DamageType> forKey(Level level, ResourceKey<DamageType> key) {
        return level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(key);
    }

    private static ResourceKey<DamageType> create(String id, String msg) {
        return LCDamageTypes.create(id, msg, msg);
    }

    private static ResourceKey<DamageType> create(String id, String msg, String player) {
        return LCDamageTypes.create(id, msg, player, player);
    }

    private static ResourceKey<DamageType> create(String id, String msg, String player, String item) {
        L2Complements.REGISTRATE.addRawLang("death.attack." + id, msg);
        L2Complements.REGISTRATE.addRawLang("death.attack." + id + ".player", player);
        L2Complements.REGISTRATE.addRawLang("death.attack." + id + ".item", item);
        return LCDamageTypes.create(id);
    }

    private static ResourceKey<DamageType> create(String id) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)L2Complements.loc(id));
    }
}

