/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.init.data;

import dev.xkmc.l2complements.events.LCAttackListener;
import dev.xkmc.l2complements.events.MagicEventHandler;
import dev.xkmc.l2complements.init.L2Complements;
import dev.xkmc.l2core.util.ConfigInit;
import net.neoforged.neoforge.common.ModConfigSpec;

public class LCConfig {
    public static final Client CLIENT = (Client)L2Complements.REGISTRATE.registerClient(Client::new);
    public static final Recipe RECIPE = (Recipe)L2Complements.REGISTRATE.registerUnsynced(Recipe::new);
    public static final Server SERVER = (Server)L2Complements.REGISTRATE.registerSynced(Server::new);

    public static void init() {
    }

    public static class Client
    extends ConfigInit {
        public final ModConfigSpec.BooleanValue renderEnchOverlay;
        public final ModConfigSpec.BooleanValue diggingPreview;

        public Client(ConfigInit.Builder builder) {
            this.markL2();
            this.renderEnchOverlay = builder.text("Render L2 enchantment book overlay").comment("Render a colored char on enchantment book to tell it apart from vanilla ones").define("renderEnchOverlay", true);
            this.diggingPreview = builder.text("Digging Enchantment Area Preview").define("diggingPreview", true);
        }
    }

    public static class Recipe
    extends ConfigInit {
        public final ModConfigSpec.BooleanValue useArsNouveauForEnchantmentRecipe;
        public final ModConfigSpec.BooleanValue enableVanillaItemRecipe;
        public final ModConfigSpec.BooleanValue enableToolRecraftRecipe;
        public final ModConfigSpec.BooleanValue enableSpawnEggRecipe;

        public Recipe(ConfigInit.Builder builder) {
            this.markL2();
            builder.push("recipe", "Recipe Toggles");
            this.useArsNouveauForEnchantmentRecipe = builder.text("Ars Nouveau: Apparatus Enchanting").comment("When Ars Nouveau is present, use apparatus recipe for enchantments").define("useArsNouveauForEnchantmentRecipe", true);
            this.enableVanillaItemRecipe = builder.text("Extra recipes for vanilla items").comment("Allow vanilla items such as elytra and ancient debris to be crafted with L2Complements materials").define("enableVanillaItemRecipe", true);
            this.enableToolRecraftRecipe = builder.text("Tool upgrade recipes").comment("Allow tools to be upgraded from tools with same type but different materials").define("enableToolRecraftRecipe", true);
            this.enableSpawnEggRecipe = builder.text("Spawn egg recipes").comment("Allow spawn eggs to be crafted with L2Complements materials").define("enableSpawnEggRecipe", true);
            builder.pop();
        }
    }

    public static class Server
    extends ConfigInit {
        public final ModConfigSpec.DoubleValue windSpeed;
        public final ModConfigSpec.IntValue belowVoid;
        public final ModConfigSpec.IntValue phantomHeight;
        public final ModConfigSpec.IntValue explosionDamage;
        public final ModConfigSpec.IntValue spaceDamage;
        public final ModConfigSpec.EnumValue<LCAttackListener.SpaceShardCondition> spaceShardDrop;
        public final ModConfigSpec.BooleanValue enableImmunityEnchantments;
        public final ModConfigSpec.EnumValue<MagicEventHandler.CleanseTest> cleansePredicate;
        public final ModConfigSpec.IntValue totemicHealDuration;
        public final ModConfigSpec.IntValue totemicHealAmount;
        public final ModConfigSpec.IntValue eternalTotemCoolDown;
        public final ModConfigSpec.BooleanValue eternalTotemGiveWarpStone;
        public final ModConfigSpec.DoubleValue windSweepIncrement;
        public final ModConfigSpec.IntValue soulFireChargeDuration;
        public final ModConfigSpec.IntValue blackFireChargeDuration;
        public final ModConfigSpec.IntValue strongFireChargePower;
        public final ModConfigSpec.BooleanValue strongFireChargeBreakBlock;
        public final ModConfigSpec.DoubleValue emeraldDamageFactor;
        public final ModConfigSpec.IntValue emeraldBaseRange;
        public final ModConfigSpec.IntValue sonicShooterDamage;
        public final ModConfigSpec.IntValue hellfireWandDamage;
        public final ModConfigSpec.IntValue iceEnchantDuration;
        public final ModConfigSpec.IntValue flameEnchantDuration;
        public final ModConfigSpec.IntValue bleedEnchantDuration;
        public final ModConfigSpec.IntValue curseEnchantDuration;
        public final ModConfigSpec.IntValue bleedEnchantMax;
        public final ModConfigSpec.DoubleValue voidTouchChance;
        public final ModConfigSpec.DoubleValue voidTouchChanceBonus;
        public final ModConfigSpec.DoubleValue lifeSyncFactor;
        public final ModConfigSpec.DoubleValue mobTypeBonus;
        public final ModConfigSpec.IntValue treeChopMaxRadius;
        public final ModConfigSpec.IntValue treeChopMaxHeight;
        public final ModConfigSpec.IntValue treeChopMaxBlock;
        public final ModConfigSpec.IntValue chainDiggingDelayThreshold;
        public final ModConfigSpec.IntValue chainDiggingBlockPerTick;
        public final ModConfigSpec.DoubleValue chainDiggingHardnessRange;
        public final ModConfigSpec.BooleanValue delayDiggingRequireEnder;

        Server(ConfigInit.Builder builder) {
            this.markL2();
            builder.push("materials", "Material Drop Conditions");
            this.windSpeed = builder.text("Captured Wind speed requirement").comment("Requirement for obtaining Captured Wind. Unit: Block per Tick").defineInRange("windSpeed", 10.0, 0.1, 100.0);
            this.belowVoid = builder.text("Void Eye depth requirement").comment("Blocks below min build height for void eye drop").defineInRange("belowVoid", 16, 0, 128);
            this.phantomHeight = builder.text("Sun Membrane height requirement").comment("Blocks above max build height for sun membrane drop").defineInRange("phantomHeight", 200, 0, 10000);
            this.explosionDamage = builder.text("Explosion Shard damage requirement").defineInRange("explosionDamage", 80, 1, 10000);
            this.spaceDamage = builder.text("Space Shard damage requirement").defineInRange("spaceDamage", 16384, 1, Integer.MAX_VALUE);
            this.spaceShardDrop = builder.text("Space Shard Toggle").comment("- Allow: Space Shard is enabled").comment("- Default: When certain mods are installed, Space Shard will be banned").comment("- Deny: Space Shard is banned").defineEnum("spaceShardDrop", (Enum)LCAttackListener.SpaceShardCondition.DEFAULT);
            builder.pop();
            builder.push("fire_charge", "Fire Charge");
            this.soulFireChargeDuration = builder.text("Soul Fire Charge effect duration in ticks").defineInRange("soulFireChargeDuration", 60, 1, 10000);
            this.blackFireChargeDuration = builder.text("Black Fire Charge effect duration in ticks").defineInRange("blackFireChargeDuration", 100, 1, 10000);
            this.strongFireChargePower = builder.text("Strong Fire Charge Power").comment("Power: 2 for Ghast, 3 for Creeper, 4 for TNT, 5 for beds, 6 for End Crystal").defineInRange("strongFireChargePower", 2, 1, 10);
            this.strongFireChargeBreakBlock = builder.text("Strong Fire Charge Breaks Block").define("strongFireChargeBreakBlock", true);
            builder.pop();
            builder.push("properties", "Item / Effect Properties");
            this.cleansePredicate = builder.text("Cleanse effect clearing test").comment("- ALL: for clearing everything").comment("- EXCEPT_BENEFICIAL: for clearing neutral and negative only").comment("- HARMFUL_ONLY: for clearing negative only").defineEnum("cleansePredicate", (Enum)MagicEventHandler.CleanseTest.ALL);
            this.emeraldDamageFactor = builder.text("Damage factor of emerald splash").defineInRange("emeraldDamageFactor", 0.5, 0.001, 1000.0);
            this.emeraldBaseRange = builder.text("Base range for emerald splash").defineInRange("emeraldBaseRange", 10, 1, 100);
            this.eternalTotemCoolDown = builder.text("Cool down of Eternal Totem of Dream").defineInRange("eternalTotemCoolDown", 2400, 0, 10000);
            this.eternalTotemGiveWarpStone = builder.text("Eternal Totem of Dream giving you warp stone").define("eternalTotemGiveWarpStone", true);
            this.totemicHealDuration = builder.text("Totemic Armor healing interval in ticks").defineInRange("totemicHealDuration", 100, 1, 1000);
            this.totemicHealAmount = builder.text("Totemic Armor healing amount").defineInRange("totemicHealAmount", 1, 1, 1000);
            this.mobTypeBonus = builder.text("Bonus damage factor for effective targets").comment(new String[]{"This is for weapons made with totemic gold and poseidite.", "When weapons with above materials is used against mob types they are effective for", "This number determines the bonus in percentage of original damage"}).defineInRange("mobTypeBonus", 1.0, 0.0, 1000.0);
            this.sonicShooterDamage = builder.text("Sonic Shooter Damage").defineInRange("sonicShooterDamage", 10, 1, 1000);
            this.hellfireWandDamage = builder.text("Hellfire Wand Damage per second charged (max 3 seconds charged)").defineInRange("hellfireWandDamage", 10, 1, 1000);
            builder.pop();
            builder.push("enchantments", "Enchantment Properties");
            this.enableImmunityEnchantments = builder.text("Enable immunity enchantments").comment("Be sure to inform players when you turn this off").define("enableImmunityEnchantments", true);
            this.windSweepIncrement = builder.text("Wind Sweep: Hit box increment per level").defineInRange("windSweepIncrement", 1.0, 0.1, 100.0);
            this.lifeSyncFactor = builder.text("Life Sync: Damage to user per durability cost").defineInRange("lifeSyncFactor", 1.0, 0.0, 1000.0);
            this.iceEnchantDuration = builder.text("Freezing Blade: Base effect duration in ticks").defineInRange("iceEnchantDuration", 100, 1, 10000);
            this.flameEnchantDuration = builder.text("Hell Fire Blade: effect duration in ticks").defineInRange("flameEnchantDuration", 60, 1, 10000);
            this.bleedEnchantDuration = builder.text("Sharp Blade: Base effect duration in ticks").defineInRange("bleedEnchantDuration", 80, 1, 10000);
            this.curseEnchantDuration = builder.text("Cursed Blade: Base effect duration in ticks").defineInRange("curseEnchantDuration", 100, 1, 10000);
            this.bleedEnchantMax = builder.text("Sharp Blade: Max effect level per enchantment level").defineInRange("bleedEnchantMax", 3, 1, 10000);
            this.voidTouchChance = builder.text("Void Touch: Chance for true damage").defineInRange("voidTouchChance", 0.05, 0.0, 1.0);
            this.voidTouchChanceBonus = builder.text("Void Touch: extra chance when damage already bypass armor or magic").defineInRange("voidTouchChanceBonus", 0.5, 0.0, 1.0);
            builder.pop();
            builder.push("enchantment_digging", "Digging Enchantment Properties");
            this.treeChopMaxRadius = builder.text("Tree Chopping max radius").comment("Max radius for blocks to be considered for tree chopping, except upward direction").defineInRange("treeChopMaxRadius", 16, 0, 32);
            this.treeChopMaxHeight = builder.text("Tree Chopping max height").comment("Max height for blocks to be considered for tree chopping.").defineInRange("treeChopMaxHeight", 256, 0, 512);
            this.treeChopMaxBlock = builder.text("Tree Chopping max block").comment("Max number of blocks to be considered for tree chopping.").defineInRange("treeChopMaxBlock", 1024, 0, 16384);
            this.chainDiggingDelayThreshold = builder.text("One-shot breaking max block count").comment("Max number of blocks to break before resort to delayed breaking").defineInRange("chainDiggingDelayThreshold", 64, 1, 1024);
            this.chainDiggingBlockPerTick = builder.text("Delayed breaking: blocks per tick").comment("Max number of blocks to break per tick in delayed breaking").defineInRange("chainDiggingBlockPerTick", 16, 1, 1024);
            this.chainDiggingHardnessRange = builder.text("Allowed hardness multiplier").comment("Max hardness blocks to break may have, as a factor of the hardness of the block broken.").comment("Apotheosis implementation of chain digging use 3 has their hardness factor.").defineInRange("chainDiggingHardnessRange", 3.0, 1.0, 100.0);
            this.delayDiggingRequireEnder = builder.text("Delayed Breaking: requires Ender Transport").comment("Delayed breaking requires Ender Transport to take effect to reduce lag").define("delayDiggingRequireEnder", true);
            builder.pop();
        }
    }
}

