/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.init;

import com.tterrag.registrate.providers.DataProviderInitializer;
import com.tterrag.registrate.providers.ProviderType;
import dev.xkmc.l2complements.content.item.misc.FireChargeItem;
import dev.xkmc.l2complements.content.item.wand.WandEffectToClient;
import dev.xkmc.l2complements.events.L2ComplementsClick;
import dev.xkmc.l2complements.events.LCAttackListener;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.LCDamageTypes;
import dev.xkmc.l2complements.init.data.LCDataMapGen;
import dev.xkmc.l2complements.init.data.LCGLMGen;
import dev.xkmc.l2complements.init.data.LCLang;
import dev.xkmc.l2complements.init.data.LCRecipeGen;
import dev.xkmc.l2complements.init.data.LCSpriteSourceProvider;
import dev.xkmc.l2complements.init.data.LCTagGen;
import dev.xkmc.l2complements.init.data.LCTrimsGen;
import dev.xkmc.l2complements.init.registrate.LCBlocks;
import dev.xkmc.l2complements.init.registrate.LCEffects;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2complements.init.registrate.LCEntities;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2complements.init.registrate.LCParticle;
import dev.xkmc.l2complements.init.registrate.LCRecipes;
import dev.xkmc.l2complements.network.EmptyRightClickToServer;
import dev.xkmc.l2complements.network.RotateDiggerToServer;
import dev.xkmc.l2core.init.L2TagGen;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.l2core.init.reg.simple.Reg;
import dev.xkmc.l2core.serial.config.PacketHandlerWithConfig;
import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.materials.vanilla.GenItemVanillaType;
import dev.xkmc.l2menustacker.click.quickaccess.DefaultQuickAccessActions;
import dev.xkmc.l2menustacker.compat.arclight.AnvilMenuArclight;
import dev.xkmc.l2serial.network.PacketHandler;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="l2complements")
@EventBusSubscriber(modid="l2complements", bus=EventBusSubscriber.Bus.MOD)
public class L2Complements {
    public static final String MODID = "l2complements";
    public static final PacketHandlerWithConfig HANDLER = new PacketHandlerWithConfig("l2complements", 4, new Function[]{e -> e.create(EmptyRightClickToServer.class, PacketHandler.NetDir.PLAY_TO_SERVER), e -> e.create(RotateDiggerToServer.class, PacketHandler.NetDir.PLAY_TO_SERVER), e -> e.create(WandEffectToClient.class, PacketHandler.NetDir.PLAY_TO_CLIENT)});
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Reg REG = new Reg("l2complements");
    public static final L2Registrate REGISTRATE = new L2Registrate("l2complements");
    public static final GenItemVanillaType MATS = new GenItemVanillaType("l2complements", REGISTRATE);

    public L2Complements() {
        LCItems.register();
        LCBlocks.register();
        LCEffects.register();
        LCParticle.register();
        LCEnchantments.register();
        LCEntities.register();
        LCRecipes.register();
        LCConfig.init();
        new L2ComplementsClick(L2Complements.loc("main"));
        AttackEventHandler.register((int)5000, (AttackListener)new LCAttackListener());
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)LCItems.SOUL_CHARGE.get()), (DispenseItemBehavior)new FireChargeItem.FireChargeBehavior((FireChargeItem)((Object)((Object)LCItems.SOUL_CHARGE.get()))));
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)LCItems.STRONG_CHARGE.get()), (DispenseItemBehavior)new FireChargeItem.FireChargeBehavior((FireChargeItem)((Object)((Object)LCItems.STRONG_CHARGE.get()))));
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)LCItems.BLACK_CHARGE.get()), (DispenseItemBehavior)new FireChargeItem.FireChargeBehavior((FireChargeItem)((Object)((Object)LCItems.BLACK_CHARGE.get()))));
            DefaultQuickAccessActions.quickAccess((MenuType)MenuType.ANVIL, (Item)LCBlocks.ETERNAL_ANVIL.asItem(), AnvilMenuArclight::new, (String)"container.repair");
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void gatherData(GatherDataEvent event) {
        REGISTRATE.addDataGenerator(ProviderType.LANG, LCLang::addTranslations);
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, LCTagGen::onBlockTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, LCTagGen::onItemTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ENTITY_TAGS, LCTagGen::onEntityTagGen);
        REGISTRATE.addDataGenerator(L2TagGen.EFF_TAGS, LCTagGen::onEffectTagGen);
        REGISTRATE.addDataGenerator(L2TagGen.ENCH_TAGS, LCTagGen::onEnchTagGen);
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, LCRecipeGen::genRecipe);
        REGISTRATE.addDataGenerator(ProviderType.DATA_MAP, LCDataMapGen::onGather);
        DataProviderInitializer init = REGISTRATE.getDataGenInitializer();
        init.addDependency(ProviderType.DYNAMIC, ProviderType.ITEM_TAGS);
        init.addDependency(ProviderType.RECIPE, L2TagGen.ENCH_TAGS);
        init.add(Registries.TRIM_MATERIAL, LCTrimsGen::build);
        new LCDamageTypes(REGISTRATE).generate();
        boolean run = event.includeServer();
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture pvd = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        gen.addProvider(run, (DataProvider)new LCSpriteSourceProvider(output, pvd, helper));
        gen.addProvider(run, (DataProvider)new LCGLMGen(output, pvd));
    }

    public static ResourceLocation loc(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }
}

