/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.events;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2complements.content.feature.EntityFeature;
import dev.xkmc.l2complements.events.event.EnderPickupEvent;
import dev.xkmc.l2complements.init.data.LCTagGen;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import java.util.Optional;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="l2complements", bus=EventBusSubscriber.Bus.GAME)
public class SpecialEquipmentEvents {
    public static ThreadLocal<Stack<Pair<ServerPlayer, BlockState>>> PLAYER = ThreadLocal.withInitial(Stack::new);

    public static boolean isVisible(LivingEntity entity, ItemStack stack) {
        if (!entity.isInvisible()) {
            return true;
        }
        if (stack.is(LCTagGen.HIDE_WITH_INVISIBILITY)) {
            return false;
        }
        return stack.getEnchantmentLevel(LCEnchantments.TRANSPARENT.holder()) == 0;
    }

    public static int blockSound(ItemStack stack) {
        if (stack.is(LCTagGen.DAMPENS_VIBRATION)) {
            return 1;
        }
        return stack.getEnchantmentLevel(LCEnchantments.DAMPENED.holder());
    }

    private static ItemStack process(Level level, ItemStack stack) {
        ItemStack input = stack.copy();
        SingleRecipeInput cont = new SingleRecipeInput(input);
        Optional opt = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)cont, level);
        if (opt.isPresent()) {
            ItemStack ans = ((SmeltingRecipe)((RecipeHolder)opt.get()).value()).assemble(cont, (HolderLookup.Provider)level.registryAccess());
            int count = ans.getCount() * input.getCount();
            ans.setCount(count);
            return ans;
        }
        return stack;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityDrop(LivingDropsEvent event) {
        LivingEntity player;
        Object object = event.getSource().getEntity();
        if (object instanceof LivingEntity && (player = (LivingEntity)object).getMainHandItem().getEnchantmentLevel(LCEnchantments.SMELT.holder()) > 0) {
            object = event.getDrops().iterator();
            while (object.hasNext()) {
                ItemEntity e2 = (ItemEntity)object.next();
                ItemStack result = SpecialEquipmentEvents.process(player.level(), e2.getItem());
                e2.setItem(result);
            }
        }
        if ((object = event.getSource().getEntity()) instanceof ServerPlayer && (player = (ServerPlayer)object).getMainHandItem().getEnchantmentLevel(LCEnchantments.ENDER_TRANSPORT.holder()) > 0) {
            for (ItemEntity e2 : event.getDrops()) {
                EnderPickupEvent ender = new EnderPickupEvent((ServerPlayer)player, e2.getItem().copy());
                NeoForge.EVENT_BUS.post((Event)ender);
                ItemStack stack = ender.getStack();
                if (!stack.isEmpty() && !player.getInventory().add(stack)) {
                    e2.setItem(stack);
                    e2.teleportTo(player.getX(), player.getY(), player.getZ());
                    continue;
                }
                e2.setItem(ItemStack.EMPTY);
            }
            event.getDrops().removeIf(e -> e.getItem().isEmpty());
        }
    }

    public static void dropExp(ServerLevel level, Vec3 pos, int exp, Operation<Void> original, @Nullable Player player) {
        if (player != null && player.getMainHandItem().getEnchantmentLevel(LCEnchantments.ENDER_TRANSPORT.holder()) > 0) {
            pos = player.position();
        }
        original.call(new Object[]{level, pos, exp});
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        ItemEntity e;
        Stack<Pair<ServerPlayer, BlockState>> players = PLAYER.get();
        if (players.isEmpty()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)players.peek().getFirst();
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            e = (ItemEntity)entity;
            if (player.getMainHandItem().getEnchantmentLevel(LCEnchantments.SMELT.holder()) > 0) {
                ItemStack result = SpecialEquipmentEvents.process(event.getLevel(), e.getItem());
                e.setItem(result);
            }
            if (player.getMainHandItem().getEnchantmentLevel(LCEnchantments.ENDER_TRANSPORT.holder()) > 0) {
                EnderPickupEvent ender = new EnderPickupEvent(player, e.getItem().copy());
                NeoForge.EVENT_BUS.post((Event)ender);
                ItemStack stack = ender.getStack();
                if (!stack.isEmpty() && !player.getInventory().add(stack)) {
                    e.setItem(stack);
                    e.teleportTo(player.getX(), player.getY(), player.getZ());
                } else {
                    event.setCanceled(true);
                    return;
                }
            }
            if (player.dampensVibrations()) {
                e.getPersistentData().putBoolean("dampensVibrations", true);
            }
        }
        if ((entity = event.getEntity()) instanceof ExperienceOrb) {
            e = (ExperienceOrb)entity;
            if (player.getMainHandItem().getEnchantmentLevel(LCEnchantments.ENDER_TRANSPORT.holder()) > 0) {
                player.takeXpDelay = 0;
                e.playerTouch((Player)player);
                if (e.isRemoved()) {
                    event.setCanceled(true);
                    return;
                }
                e.teleportTo(player.getX(), player.getY(), player.getZ());
            }
            if (player.dampensVibrations()) {
                e.getPersistentData().putBoolean("dampensVibrations", true);
            }
        }
    }

    public static void pushPlayer(ServerPlayer player, BlockPos pos) {
        PLAYER.get().push((Pair<ServerPlayer, BlockState>)Pair.of((Object)player, (Object)player.level().getBlockState(pos)));
    }

    public static void popPlayer(ServerPlayer player) {
        if (PLAYER.get().peek().getFirst() == player) {
            PLAYER.get().pop();
        }
    }

    public static boolean canWalkOn(FluidState state, LivingEntity self) {
        if (state.getType() == Fluids.LAVA) {
            double dy = self.getY();
            double vy = self.getDeltaMovement().y;
            if (vy > 0.0 && dy - Math.floor(dy) < 0.5) {
                return false;
            }
            return EntityFeature.LAVA_WALKER.test(self);
        }
        return false;
    }

    public static boolean canSee(Entity instance, Operation<Boolean> original) {
        boolean ans = (Boolean)original.call(new Object[]{instance});
        if (ans) {
            return true;
        }
        if (instance instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)instance;
            if (le.isInLava() && (EntityFeature.FIRE_REJECT.test(le) || EntityFeature.ENVIRONMENTAL_REJECT.test(le) || EntityFeature.LAVA_WALKER.test(le))) {
                return true;
            }
            if (le.isInPowderSnow && (PowderSnowBlock.canEntityWalkOnPowderSnow((Entity)instance) || EntityFeature.ENVIRONMENTAL_REJECT.test(le))) {
                return true;
            }
        }
        return false;
    }
}

