/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.events;

import dev.xkmc.l2complements.content.item.misc.WarpStone;
import dev.xkmc.l2complements.content.recipe.BurntRecipe;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2complements.init.registrate.LCRecipes;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.GrindstoneEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="l2complements", bus=EventBusSubscriber.Bus.GAME)
public class MaterialEventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityDeath(LivingDeathEvent event) {
        Phantom phantom;
        Level level;
        LivingEntity player;
        Entity entity;
        EnderMan ender;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EnderMan && !(ender = (EnderMan)livingEntity).level().isClientSide() && (entity = event.getSource().getEntity()) instanceof Player) {
            player = (Player)entity;
            if (ender.isCreepy() && ender.getOnPos().getY() <= ender.level().getMinBuildHeight() - (Integer)LCConfig.SERVER.belowVoid.get()) {
                ender.spawnAtLocation(LCItems.VOID_EYE.asStack());
            }
        }
        if ((player = event.getEntity()) instanceof Phantom && !(level = (phantom = (Phantom)player).level()).isClientSide() && phantom.getOnPos().getY() >= level.getMaxBuildHeight() + (Integer)LCConfig.SERVER.phantomHeight.get() && level.isDay() && level.canSeeSky(phantom.getOnPos()) && phantom.isOnFire()) {
            phantom.spawnAtLocation(LCItems.SUN_MEMBRANE.asStack());
        }
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (event.getItemStack().is((Item)LCItems.WIND_BOTTLE.get()) && (entity = event.getTarget()) instanceof ShulkerBullet) {
            ShulkerBullet bullet = (ShulkerBullet)entity;
            bullet.hurt(event.getLevel().damageSources().playerAttack(event.getEntity()), 1.0f);
            event.getItemStack().shrink(1);
            event.getEntity().getInventory().placeItemBackInInventory(LCItems.CAPTURED_BULLET.asStack());
        }
    }

    @SubscribeEvent
    public static void onGrind(GrindstoneEvent.OnPlaceItem event) {
        ItemStack copy;
        if (event.getTopItem().getItem() instanceof WarpStone && (copy = event.getTopItem().copy()).has((DataComponentType)LCItems.POS_DATA.get())) {
            copy.remove((DataComponentType)LCItems.POS_DATA.get());
            event.setOutput(copy);
            event.setXp(0);
        }
    }

    public static void onItemKill(Level level, Entity entity, ItemStack stack) {
        BurntRecipe.Inv inv = new BurntRecipe.Inv();
        inv.setItem(0, stack);
        Optional opt = level.getRecipeManager().getRecipeFor((RecipeType)LCRecipes.RT_BURNT.get(), (RecipeInput)inv, level);
        if (opt.isPresent()) {
            BurntRecipe r = (BurntRecipe)((RecipeHolder)opt.get()).value();
            ItemStack result = r.assemble(inv, (HolderLookup.Provider)level.registryAccess());
            int chance = r.chance;
            int trial = stack.getCount();
            int det = trial / chance;
            if (level.random.nextInt(chance) < (trial %= chance)) {
                ++det;
            }
            det *= result.getCount();
            while (det > 0) {
                int sup = Math.min(det, result.getMaxStackSize());
                det -= sup;
                ItemStack copy = result.copy();
                copy.setCount(sup);
                level.addFreshEntity((Entity)new ItemEntity(level, entity.getX(), entity.getY(), entity.getZ(), copy, 0.0, 0.5, 0.0));
            }
        }
    }
}

