/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.events;

import dev.xkmc.l2complements.compat.CurioCompat;
import dev.xkmc.l2complements.content.effect.CleanseEffect;
import dev.xkmc.l2complements.content.enchantment.core.SoulBoundPlayerData;
import dev.xkmc.l2complements.content.enchantment.digging.DiggerHelper;
import dev.xkmc.l2complements.content.feature.EntityFeature;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.LCTagGen;
import dev.xkmc.l2complements.init.registrate.LCEffects;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2core.base.effects.ForceAddEffectEvent;
import dev.xkmc.l2core.events.SchedulerHandler;
import dev.xkmc.l2core.init.reg.ench.LegacyEnchantment;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="l2complements", bus=EventBusSubscriber.Bus.GAME)
public class MagicEventHandler {
    @SubscribeEvent
    public static void onLivingAttack(LivingIncomingDamageEvent event) {
        OwnableEntity ownable;
        Entity entity;
        if (EntityFeature.OWNER_PROTECTION.test(event.getEntity()) && (entity = event.getSource().getEntity()) instanceof OwnableEntity && (ownable = (OwnableEntity)entity).getOwner() == event.getEntity()) {
            event.setCanceled(true);
        }
        if (!((Boolean)LCConfig.SERVER.enableImmunityEnchantments.get()).booleanValue()) {
            return;
        }
        if (EntityFeature.INVINCIBLE.test(event.getEntity())) {
            event.setCanceled(true);
        }
        if (event.getSource().is(DamageTypeTags.BYPASSES_EFFECTS) || event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return;
        }
        if (EntityFeature.ENVIRONMENTAL_REJECT.test(event.getEntity()) && event.getSource().getEntity() == null) {
            event.setCanceled(true);
        }
        if (EntityFeature.MAGIC_REJECT.test(event.getEntity()) && event.getSource().is(Tags.DamageTypes.IS_MAGIC)) {
            event.setCanceled(true);
        }
        if (event.getSource().is(DamageTypeTags.BYPASSES_ENCHANTMENTS)) {
            return;
        }
        if (EntityFeature.PROJECTILE_REJECT.test(event.getEntity()) && event.getSource().is(DamageTypeTags.IS_PROJECTILE)) {
            event.setCanceled(true);
        }
        if (EntityFeature.FIRE_REJECT.test(event.getEntity()) && event.getSource().is(DamageTypeTags.IS_FIRE)) {
            event.setCanceled(true);
        }
        if (EntityFeature.EXPLOSION_REJECT.test(event.getEntity()) && event.getSource().is(DamageTypeTags.IS_EXPLOSION)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Post event) {
        LivingEntity le;
        Entity e = event.getEntity();
        if (e instanceof LivingEntity && (le = (LivingEntity)e).isOnFire() && EntityFeature.FIRE_REJECT.test(le)) {
            event.getEntity().clearFire();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onInventoryDrop(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        event.getDrops().removeIf(e -> e.getItem().getEnchantmentLevel(LCEnchantments.SOUL_BOUND.holder()) > 0 && SoulBoundPlayerData.addToPlayer(player, e.getItem()));
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent event) {
        if (event.getEntity().hasEffect(LCEffects.CURSE.holder())) {
            event.setCanceled(true);
            return;
        }
        float amount = event.getAmount();
        for (ItemStack stack : CurioCompat.getAllSlots(event.getEntity())) {
            int lv;
            if (!stack.isEnchanted() || !stack.isDamaged() || (lv = stack.getEnchantmentLevel(LCEnchantments.LIFE_MENDING.holder())) <= 0) continue;
            int damage = stack.getDamageValue();
            int repair = 1 << lv - 1;
            int armor = stack.getEnchantmentLevel(LCEnchantments.DURABLE_ARMOR.holder());
            if (armor > 0) {
                repair *= 1 + armor;
            }
            int recover = Math.min(damage, (int)Math.floor(amount * (float)repair));
            stack.setDamageValue(damage - recover);
            if (!((double)(amount -= 1.0f * (float)recover / (float)repair) < 0.001)) continue;
            break;
        }
        event.setAmount(amount);
    }

    @SubscribeEvent
    public static void onTeleport(EntityTeleportEvent event) {
        LivingEntity le;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (le = (LivingEntity)entity).hasEffect(LCEffects.INCARCERATE.holder())) {
            event.setCanceled(true);
        }
    }

    public static boolean isSkill(MobEffectInstance ins, LivingEntity entity) {
        if (ins.getEffect().is(LCTagGen.SKILL_EFFECT)) {
            return true;
        }
        CleanseTest pred = (CleanseTest)((Object)LCConfig.SERVER.cleansePredicate.get());
        if (((MobEffect)ins.getEffect().value()).isBeneficial() && pred != CleanseTest.ALL) {
            return true;
        }
        if (((MobEffect)ins.getEffect().value()).getCategory() == MobEffectCategory.NEUTRAL && pred == CleanseTest.HARMFUL_ONLY) {
            return true;
        }
        Optional tag = BuiltInRegistries.MOB_EFFECT.getTag(LCTagGen.SKILL_EFFECT);
        if (tag.isPresent() && ((HolderSet.Named)tag.get()).contains(ins.getEffect())) {
            return true;
        }
        return CurioCompat.testEffect(ins, entity);
    }

    @SubscribeEvent
    public static void onPotionTest(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance() == null) {
            return;
        }
        if (event.getEntity().hasEffect(LCEffects.CLEANSE.holder())) {
            if (MagicEventHandler.isSkill(event.getEffectInstance(), event.getEntity())) {
                return;
            }
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    @SubscribeEvent
    public static void onForceAdd(ForceAddEffectEvent event) {
        if (event.getEntity().hasEffect(LCEffects.CLEANSE.holder())) {
            if (MagicEventHandler.isSkill(event.getEffectInstance(), event.getEntity())) {
                return;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPotionAdded(MobEffectEvent.Added event) {
        if (event.getEntity().hasEffect(LCEffects.CLEANSE.holder())) {
            MobEffectInstance ins = event.getEffectInstance();
            if (ins == null || MagicEventHandler.isSkill(ins, event.getEntity())) {
                return;
            }
            SchedulerHandler.schedule(() -> CleanseEffect.clearOnEntity(event.getEntity()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack stack = player2.getMainHandItem();
        DiggerHelper.Digger ent = DiggerHelper.getDigger(stack);
        if (ent == null) {
            return;
        }
        ent.digger().onBlockBreak(player2, event.getPos(), stack, Math.min(((Enchantment)ent.ench().value()).getMaxLevel(), ent.level()));
    }

    public static Stream<Holder<Enchantment>> lootEnch(Stream<Holder<Enchantment>> instance) {
        return instance.filter(e -> LegacyEnchantment.firstOf((Holder)e, LCEnchantments.CRAFT) == null);
    }

    public static enum CleanseTest {
        ALL,
        EXCEPT_BENEFICIAL,
        HARMFUL_ONLY;

    }
}

