/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.events;

import dev.xkmc.l2complements.content.enchantment.core.SourceModifierEnchantment;
import dev.xkmc.l2complements.content.enchantment.legacy.AbstractBladeEnchantment;
import dev.xkmc.l2complements.content.enchantment.legacy.AbstractThornEnchantment;
import dev.xkmc.l2complements.content.enchantment.legacy.VoidTouchEnchantment;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2core.init.reg.ench.EnchHolder;
import dev.xkmc.l2core.init.reg.ench.LegacyEnchantment;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import java.util.HashSet;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;

public class LCAttackListener
implements AttackListener {
    public static final HashSet<String> BAN_SPACE_SHARD = new HashSet();

    public static boolean isSpaceShardBanned() {
        SpaceShardCondition config = (SpaceShardCondition)((Object)LCConfig.SERVER.spaceShardDrop.get());
        if (config == SpaceShardCondition.DENY) {
            return true;
        }
        if (config == SpaceShardCondition.ALLOW) {
            return false;
        }
        for (String e : BAN_SPACE_SHARD) {
            if (!ModList.get().isLoaded(e)) continue;
            return true;
        }
        return false;
    }

    public void onCreateSource(CreateSourceEvent event) {
        if (event.getOriginal().equals(DamageTypes.MOB_ATTACK) || event.getOriginal().equals(DamageTypes.PLAYER_ATTACK)) {
            ItemStack stack = event.getAttacker().getMainHandItem();
            for (EnchHolder e : LegacyEnchantment.findAll((ItemStack)stack, SourceModifierEnchantment.class, (boolean)false)) {
                ((SourceModifierEnchantment)e.val()).modify(event, stack, e.lv());
            }
        }
    }

    public void onDamageFinalized(DamageData.DefenceMax data) {
        LivingEntity livingEntity = data.getTarget();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            float damage = data.getDamageIncoming();
            if (data.getSource().is(DamageTypeTags.IS_EXPLOSION) && damage >= (float)((Integer)LCConfig.SERVER.explosionDamage.get()).intValue() && data.getDamageFinal() < player.getHealth() + player.getAbsorptionAmount()) {
                player.getInventory().placeItemBackInInventory(LCItems.EXPLOSION_SHARD.asStack());
            }
        }
        if ((livingEntity = data.getTarget()) instanceof Chicken) {
            Chicken chicken = (Chicken)livingEntity;
            if (data.getSource().getMsgId().equals("sonic_boom") && data.getDamageFinal() < chicken.getHealth() + chicken.getAbsorptionAmount()) {
                chicken.spawnAtLocation(LCItems.RESONANT_FEATHER.asStack());
            }
        }
        if (data.getSource().is(DamageTypeTags.IS_PROJECTILE) && data.getAttacker() instanceof Player && !LCAttackListener.isSpaceShardBanned() && data.getDamageIncoming() >= (float)((Integer)LCConfig.SERVER.spaceDamage.get()).intValue()) {
            data.getTarget().spawnAtLocation(LCItems.SPACE_SHARD.asStack());
        }
    }

    public boolean onAttack(DamageData.Attack data) {
        if (!data.getWeapon().isEmpty()) {
            VoidTouchEnchantment.postAttack(data, data.getWeapon());
        }
        return false;
    }

    public void onHurt(DamageData.Offence data) {
        if (!data.getWeapon().isEmpty()) {
            VoidTouchEnchantment.initAttack(data, data.getWeapon());
            LivingEntity attacker = data.getAttacker();
            if (attacker != null) {
                LegacyEnchantment.findAll((ItemStack)data.getWeapon(), AbstractBladeEnchantment.class, (boolean)true).forEach(e -> ((AbstractBladeEnchantment)((Object)((Object)e.val()))).onAttack(attacker, data.getTarget(), e.lv()));
            }
        }
    }

    public void onDamage(DamageData.Defence data) {
        if (!data.getWeapon().isEmpty()) {
            VoidTouchEnchantment.initDamage(data, data.getWeapon());
            LivingEntity attacker = data.getAttacker();
            if (attacker != null) {
                LegacyEnchantment.accumulateOnEntity((LivingEntity)data.getTarget(), AbstractThornEnchantment.class, (boolean)true).forEach((k, v) -> k.onDamage(attacker, data.getTarget(), (int)v));
            }
        }
    }

    static {
        BAN_SPACE_SHARD.add("l2artifacts");
        BAN_SPACE_SHARD.add("l2hostility");
        BAN_SPACE_SHARD.add("apotheosis");
    }

    public static enum SpaceShardCondition {
        ALLOW,
        DEFAULT,
        DENY;

    }
}

