/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.events;

import dev.xkmc.l2complements.content.client.RangeDiggingOutliner;
import dev.xkmc.l2complements.content.feature.EntityFeature;
import dev.xkmc.l2complements.init.L2Complements;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.LCKeys;
import dev.xkmc.l2complements.network.RotateDiggerToServer;
import dev.xkmc.l2core.util.Proxy;
import dev.xkmc.l2itemselector.events.GenericKeyEvent;
import dev.xkmc.l2serial.network.SimplePacketBase;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderBlockScreenEffectEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Vector3f;

@EventBusSubscriber(value={Dist.CLIENT}, modid="l2complements", bus=EventBusSubscriber.Bus.GAME)
public class ClientEventHandler {
    @SubscribeEvent
    public static void onScreenEffect(RenderBlockScreenEffectEvent event) {
        if (event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.FIRE && EntityFeature.FIRE_REJECT.test((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInput(GenericKeyEvent event) {
        if (event.test(LCKeys.DIG.map.getKey()) && event.getAction() == 1 && Proxy.getClientPlayer() != null && Proxy.getClientPlayer().getMainHandItem().isEnchanted()) {
            L2Complements.HANDLER.toServer((SimplePacketBase)new RotateDiggerToServer(Screen.hasShiftDown()));
        }
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (!((Boolean)LCConfig.CLIENT.diggingPreview.get()).booleanValue()) {
            return;
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            ClientEventHandler.renderOutline(event, true);
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            ClientEventHandler.renderOutline(event, false);
        }
    }

    private static void renderOutline(RenderLevelStageEvent event, boolean outline) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Camera cam = event.getCamera();
        Entity entity = cam.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!Minecraft.getInstance().gameRenderer.shouldRenderBlockOutline()) {
            return;
        }
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult bhit = (BlockHitResult)hitResult;
        BlockPos pos = bhit.getBlockPos();
        BlockState state = level.getBlockState(pos);
        if (state.isAir() || !level.getWorldBorder().isWithinBounds(pos)) {
            return;
        }
        Vector3f vec = cam.getPosition().toVector3f();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        RangeDiggingOutliner.renderMoreOutlines(player, pos, buffer, event.getPoseStack(), vec.x, vec.y, vec.z, outline);
    }
}

