/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.particle;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EmeraldParticle
extends TextureSheetParticle {
    public static final int LIFE = 20;

    protected EmeraldParticle(ClientLevel world, double x0, double y0, double z0, double x1, double y1, double z1) {
        super(world, x0, y0, z0, 0.0, 0.0, 0.0);
        this.xd = (x1 - x0) / 20.0;
        this.yd = (y1 - y0) / 20.0;
        this.zd = (z1 - z0) / 20.0;
        this.setSize(0.03f, 0.03f);
        this.gravity = 0.0f;
        this.lifetime = 20;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
        }
    }

    public static class Factory
    implements ParticleEngine.SpriteParticleRegistration<SimpleParticleType> {
        public ParticleProvider<SimpleParticleType> create(SpriteSet sprite) {
            return (type, world, x0, y0, z0, x1, y1, z1) -> {
                EmeraldParticle part = new EmeraldParticle(world, x0, y0, z0, x1, y1, z1);
                part.pickSprite(sprite);
                return part;
            };
        }
    }
}

