/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.wand;

import dev.xkmc.l2complements.content.item.wand.WandEffectToClient;
import dev.xkmc.l2complements.init.data.LCLang;
import dev.xkmc.l2complements.init.registrate.LCEffects;
import dev.xkmc.l2core.base.effects.EffectUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;

public class WinterStormWand
extends Item {
    public static final int RANGE = 64;
    public static final int CHARGE = 100;
    public static final int SIZE_0 = 3;
    public static final int SIZE_1 = 7;

    public WinterStormWand(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack stack, int remain) {
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        Vec3 center = player.position();
        int time = this.getUseDuration(stack, user) - remain;
        if (!level.isClientSide()) {
            if (remain % 20 == 0) {
                stack.hurtAndBreak(1, user, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
            }
            WinterStormWand.tickServer(user, level, center, time);
        }
    }

    public static void tickServer(LivingEntity user, Level level, Vec3 center, int time) {
        WandEffectToClient.Type.WINTERSTORM.send(user, center, time);
        double radius = 3.0 + (double)Math.min(100, time) * 1.0 * 7.0 / 100.0;
        List list = level.getEntities(EntityTypeTest.forClass(LivingEntity.class), user.getBoundingBox().inflate(radius), e -> e instanceof Mob && e != user && !e.isAlliedTo((Entity)user) && !user.isAlliedTo((Entity)e));
        for (LivingEntity e2 : list) {
            double dist = (double)user.distanceTo((Entity)e2) / radius;
            if (dist > 1.0) continue;
            Vec3 vec = e2.position().subtract(user.position()).normalize().scale((1.0 - dist) * 0.2);
            e2.push(vec.x, vec.y, vec.z);
            if (e2.getTicksFrozen() < 140) {
                e2.setTicksFrozen(140);
            }
            EffectUtil.refreshEffect((LivingEntity)e2, (MobEffectInstance)new MobEffectInstance(LCEffects.ICE, 40), (Entity)user);
        }
    }

    public static void tickClient(Level level, Vec3 center, int time) {
        double radius = 3.0 + (double)Math.min(100, time) * 1.0 * 7.0 / 100.0;
        for (int i = 0; i < 5; ++i) {
            float tpi = (float)Math.PI * 2;
            Vec3 v = new Vec3(0.0, 1.0, 0.0);
            v = v.xRot(tpi / 4.0f).yRot(level.getRandom().nextFloat() * tpi);
            Vec3 v0 = v.scale(radius);
            Vec3 v1 = v.yRot(tpi * 0.375f);
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, center.x + v0.x, center.y + v0.y + 0.5, center.z + v0.z, v1.x, v1.y, v1.z);
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity user, int remain) {
        if (!(user instanceof Player)) {
            return;
        }
        stack.hurtAndBreak(1, user, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
    }

    public int getUseDuration(ItemStack stack, LivingEntity le) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LCLang.IDS.WINTERSTORM_WAND.get(new Object[0]).withStyle(ChatFormatting.GRAY));
    }
}

