/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.wand;

import dev.xkmc.l2complements.content.item.wand.WandItem;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.LCLang;
import dev.xkmc.l2library.content.raytrace.IGlowingTarget;
import dev.xkmc.l2library.content.raytrace.RayTraceUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SonicShooter
extends WandItem
implements IGlowingTarget {
    private static final int RANGE = 17;

    public SonicShooter(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (level.isClientSide() && selected && entity instanceof Player) {
            Player player = (Player)entity;
            RayTraceUtil.clientUpdateTarget((Player)player, (double)17.0);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        player.playSound(SoundEvents.WARDEN_SONIC_CHARGE, 3.0f, 1.0f);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (user instanceof Player) {
                Vec3 src = user.getEyePosition();
                Vec3 dst = RayTraceUtil.getRayTerm((Vec3)src, (float)user.getXRot(), (float)user.getYRot(), (double)17.0);
                Vec3 dir = dst.subtract(src).normalize();
                SonicShooter.shoot(sl, user, stack, src, dir);
            }
        }
        return stack;
    }

    public static void shoot(ServerLevel level, LivingEntity user, ItemStack stack, Vec3 src, Vec3 dir) {
        for (int i = 1; i < 17; ++i) {
            Vec3 vec33 = src.add(dir.scale((double)i));
            level.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, vec33.x, vec33.y, vec33.z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        ArrayList<LivingEntity> target = new ArrayList<LivingEntity>();
        AABB aabb = new AABB(src, src.add(dir.scale(17.0)));
        block1: for (Entity entity : level.getEntities((Entity)user, aabb)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity x = (LivingEntity)entity;
            AABB box = x.getBoundingBox().inflate(1.0);
            for (int i = 0; i <= 17; ++i) {
                if (!box.contains(src.add(dir.scale((double)i)))) continue;
                target.add(x);
                continue block1;
            }
        }
        for (LivingEntity livingEntity : target) {
            livingEntity.hurt(level.damageSources().sonicBoom((Entity)user), (float)((Integer)LCConfig.SERVER.sonicShooterDamage.get()).intValue());
            double d1 = 0.5 * (1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            double d0 = 2.5 * (1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            livingEntity.push(dir.x() * d0, dir.y() * d1, dir.z() * d0);
        }
        user.playSound(SoundEvents.WARDEN_SONIC_BOOM, 3.0f, 1.0f);
        stack.hurtAndBreak(1, user, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
    }

    public int getUseDuration(ItemStack stack, LivingEntity e) {
        return 34;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getDistance(ItemStack itemStack) {
        return 17;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)LCLang.IDS.SONIC_SHOOTER.get(new Object[0]).withStyle(ChatFormatting.GRAY));
    }
}

