/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.wand;

import dev.xkmc.l2complements.content.item.wand.WandEffectToClient;
import dev.xkmc.l2complements.content.item.wand.WandItem;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.LCLang;
import dev.xkmc.l2library.content.raytrace.RayTraceUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class HellfireWand
extends WandItem {
    public static final int RANGE = 64;
    public static final int CHARGE = 200;
    public static final int SIZE = 10;

    public HellfireWand(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack stack, int remain) {
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        BlockHitResult result = RayTraceUtil.rayTraceBlock((Level)level, (Player)player, (double)64.0);
        Vec3 center = result.getLocation();
        int time = this.getUseDuration(stack, user) - remain;
        if (level.isClientSide()) {
            return;
        }
        HellfireWand.renderRegionServer(user, center, time);
    }

    public static void renderRegionServer(LivingEntity user, Vec3 center, int time) {
        WandEffectToClient.Type.HELLFIRE_TICK.send(user, center, time);
    }

    public static void renderRegionClient(Level level, Vec3 center, int time) {
        double radius = (double)Math.min(200, time) * 1.0 * 10.0 / 200.0;
        for (int i = 0; i < 5; ++i) {
            float tpi = (float)Math.PI * 2;
            Vec3 v0 = new Vec3(0.0, radius, 0.0);
            v0 = v0.xRot(tpi / 4.0f).yRot(level.getRandom().nextFloat() * tpi);
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.FLAME, center.x + v0.x, center.y + v0.y + 0.5, center.z + v0.z, 0.0, 0.0, 0.0);
        }
    }

    public static void trigger(LivingEntity user, ServerLevel sl, Vec3 center, int time) {
        WandEffectToClient.Type.HELLFIRE_TRIGGER.send(user, center, time);
        float damage = (float)((Integer)LCConfig.SERVER.hellfireWandDamage.get()).intValue() * Math.min(3.0f, (float)time / 20.0f);
        double radius = (double)Math.min(200, time) * 1.0 * 10.0 / 200.0;
        for (Entity e : sl.getEntities((Entity)user, AABB.ofSize((Vec3)center.add(0.0, radius, 0.0), (double)(radius * 2.0), (double)(radius * 2.0), (double)(radius * 2.0)))) {
            if (!(e instanceof LivingEntity)) continue;
            LivingEntity x = (LivingEntity)e;
            if (e == user || e.isAlliedTo((Entity)user) || user.isAlliedTo(e)) continue;
            x.hurt(sl.damageSources().indirectMagic((Entity)user, null), damage);
        }
    }

    public static void renderPentagonClient(Level level, Vec3 center, int time) {
        level.playSound(null, center.x, center.y, center.z, SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 3.0f, 1.0f);
        double radius = (double)Math.min(200, time) * 1.0 * 10.0 / 200.0;
        double side = 1.644;
        double perimeter = Math.PI * 2;
        double total = side * 5.0 + perimeter;
        int size = time * 2;
        for (int i = 0; i < size; ++i) {
            Vec3 v0;
            double perc = (double)i * 1.0 / (double)size * total;
            if (perc < side * 5.0) {
                int start = (int)Math.floor(perc / side);
                Vec3 tip = new Vec3(0.0, radius, 0.0);
                tip = tip.xRot(1.5707964f).yRot((float)(2.5132741228718345 * (double)start));
                Vec3 next = tip.yRot(2.5132742f);
                v0 = tip.add(next.subtract(tip).scale(perc / side - (double)start));
                level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SOUL, center.x + v0.x, center.y + v0.y + 0.5, center.z + v0.z, 0.0, 1.0, 0.0);
                continue;
            }
            v0 = new Vec3(0.0, radius, 0.0);
            v0 = v0.xRot(1.5707964f).yRot((float)(perc - side * 5.0));
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, center.x + v0.x, center.y + v0.y + 0.5, center.z + v0.z, 0.0, 1.0, 0.0);
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity user, int remain) {
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        stack.hurtAndBreak(1, user, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
        BlockHitResult result = RayTraceUtil.rayTraceBlock((Level)level, (Player)player, (double)64.0);
        Vec3 center = result.getLocation();
        int time = this.getUseDuration(stack, user) - remain;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            HellfireWand.trigger(user, sl, center, time);
        }
        player.getCooldowns().addCooldown((Item)this, 10);
    }

    public int getUseDuration(ItemStack stack, LivingEntity e) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LCLang.IDS.HELLFIRE_WAND.get(new Object[0]).withStyle(ChatFormatting.GRAY));
    }
}

