/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.wand;

import dev.xkmc.l2complements.content.item.wand.WandItem;
import dev.xkmc.l2complements.content.recipe.DiffusionRecipe;
import dev.xkmc.l2complements.init.data.LCLang;
import dev.xkmc.l2complements.init.registrate.LCRecipes;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.function.Consumers;

public class DiffusionWand
extends WandItem {
    public DiffusionWand(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        Level level = ctx.getLevel();
        BlockState state = level.getBlockState(pos);
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            BlockState replace = null;
            for (Direction dire : Direction.values()) {
                BlockPos npos = pos.relative(dire);
                BlockState nstate = level.getBlockState(npos);
                DiffusionRecipe.Inv inv = new DiffusionRecipe.Inv();
                inv.setItem(0, state.getBlock().asItem().getDefaultInstance());
                inv.setItem(1, nstate.getBlock().asItem().getDefaultInstance());
                Optional opt = level.getRecipeManager().getRecipeFor((RecipeType)LCRecipes.RT_DIFFUSION.get(), (RecipeInput)inv, level);
                if (!opt.isPresent()) continue;
                BlockState result = ((DiffusionRecipe)((RecipeHolder)opt.get()).value()).result.defaultBlockState();
                level.setBlockAndUpdate(npos, result);
                replace = result;
            }
            if (replace != null) {
                level.setBlockAndUpdate(pos, replace);
                ItemStack stack = ctx.getItemInHand();
                if (ctx.getPlayer() != null) {
                    stack.hurtAndBreak(1, (LivingEntity)ctx.getPlayer(), LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
                } else {
                    stack.hurtAndBreak(1, sl, null, Consumers.nop());
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)LCLang.IDS.DIFFUSION_WAND.get(new Object[0]).withStyle(ChatFormatting.GRAY));
    }
}

