/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.misc;

import dev.xkmc.l2complements.init.data.LCLang;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2core.util.TeleportTool;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WarpStone
extends Item {
    public final boolean fragile;

    public static void set(ItemStack stack, Level level, Entity e) {
        LCItems.POS_DATA.set(stack, (Object)new PosData(level.dimension().location(), e.position().add(0.0, 0.001, 0.0)));
    }

    public WarpStone(Item.Properties props, boolean fragile) {
        super(props);
        this.fragile = fragile;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        return this.use(level, player, stack, e -> player.onEquippedItemBroken(e, LivingEntity.getSlotForHand((InteractionHand)hand)));
    }

    public void use(ServerPlayer player, ItemStack stack) {
        this.use(player.level(), (Player)player, stack, e -> {});
    }

    private InteractionResultHolder<ItemStack> use(Level level, Player player, ItemStack stack, Consumer<Item> breaker) {
        PosData ppos = (PosData)LCItems.POS_DATA.get(stack);
        if (ppos != null) {
            if (!level.isClientSide()) {
                ResourceKey dim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ppos.id());
                Vec3 pos = ppos.pos();
                ServerLevel lv = ((ServerLevel)level).getServer().getLevel(dim);
                if (lv != null) {
                    TeleportTool.performTeleport((Entity)player, (ServerLevel)lv, (double)pos.x, (double)pos.y, (double)pos.z, (float)player.getYRot(), (float)player.getXRot());
                    if (!this.fragile) {
                        stack.hurtAndBreak(1, lv, (LivingEntity)player, breaker);
                    }
                }
            }
            if (this.fragile) {
                stack.shrink(1);
                return InteractionResultHolder.consume((Object)stack);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        if (!level.isClientSide()) {
            WarpStone.set(stack, level, (Entity)player);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        int dur;
        PosData pos = (PosData)LCItems.POS_DATA.get(stack);
        int n = dur = this.fragile ? 1 : stack.getMaxDamage() - this.getDamage(stack);
        if (pos != null) {
            MutableComponent clevel = Component.translatable((String)pos.id().toString());
            Vec3 bpos = pos.pos();
            list.add((Component)LCLang.IDS.WARP_POS.get(clevel, Math.round(bpos.x), Math.round(bpos.y), Math.round(bpos.x)).withStyle(ChatFormatting.GRAY));
            list.add((Component)LCLang.IDS.WARP_TELEPORT.get(dur).withStyle(ChatFormatting.GRAY));
            if (!this.fragile) {
                list.add((Component)LCLang.IDS.WARP_GRIND.get(new Object[0]).withStyle(ChatFormatting.GRAY));
            }
        } else {
            list.add((Component)LCLang.IDS.WARP_RECORD.get(dur).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has((DataComponentType)LCItems.POS_DATA.get());
    }

    public record PosData(ResourceLocation id, Vec3 pos) {
    }
}

