/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.misc;

import dev.xkmc.l2complements.content.entity.fireball.BaseFireball;
import dev.xkmc.l2complements.content.item.misc.TooltipItem;
import dev.xkmc.l2complements.init.data.LCLang;
import dev.xkmc.l2library.content.raytrace.RayTraceUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FireChargeItem<T extends BaseFireball<T>>
extends TooltipItem {
    private final PlayerFire<T> playerFire;
    private final BlockFire<T> blockFire;

    public FireChargeItem(Item.Properties pProperties, PlayerFire<T> playerFire, BlockFire<T> blockFire, Supplier<MutableComponent> tooltip) {
        super(pProperties, tooltip);
        this.playerFire = playerFire;
        this.blockFire = blockFire;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        RandomSource r = player.getRandom();
        level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 1.0f, (r.nextFloat() - r.nextFloat()) * 0.2f + 1.0f);
        if (!level.isClientSide) {
            Vec3 v = RayTraceUtil.getRayTerm((Vec3)Vec3.ZERO, (float)player.getXRot(), (float)player.getYRot(), (double)1.0);
            T t = this.playerFire.create(player, Vec3.ZERO, level);
            t.setItem(itemstack);
            t.setPos(player.getEyePosition().add(0.0, -0.1, 0.0).add(v));
            t.setDeltaMovement(v);
            level.addFreshEntity(t);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LCLang.IDS.CHARGE_THROW.get(new Object[0]).withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, level, list, flag);
    }

    public static interface PlayerFire<T extends BaseFireball<T>> {
        public T create(Player var1, Vec3 var2, Level var3);
    }

    public static interface BlockFire<T extends BaseFireball<T>> {
        public T create(double var1, double var3, double var5, Vec3 var7, Level var8);
    }

    public class FireChargeBehavior
    extends DefaultDispenseItemBehavior {
        public ItemStack execute(BlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            Position position = DispenserBlock.getDispensePosition((BlockSource)source);
            double d0 = position.x() + (double)((float)direction.getStepX() * 0.3f);
            double d1 = position.y() + (double)((float)direction.getStepY() * 0.3f);
            double d2 = position.z() + (double)((float)direction.getStepZ() * 0.3f);
            ServerLevel level = source.level();
            RandomSource randomsource = level.random;
            double d3 = randomsource.triangle((double)direction.getStepX(), 0.11485);
            double d4 = randomsource.triangle((double)direction.getStepY(), 0.11485);
            double d5 = randomsource.triangle((double)direction.getStepZ(), 0.11485);
            Object t = FireChargeItem.this.blockFire.create(d0, d1, d2, Vec3.ZERO, (Level)level);
            t.setItem(stack);
            t.setDeltaMovement(new Vec3(d3, d4, d5).normalize());
            level.addFreshEntity(t);
            stack.shrink(1);
            return stack;
        }

        protected void playSound(BlockSource level) {
            level.level().levelEvent(1018, level.pos(), 0);
        }
    }
}

