/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.misc;

import dev.xkmc.l2complements.content.item.misc.ILCTotem;
import dev.xkmc.l2complements.content.item.misc.WarpStone;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.LCLang;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2core.util.Proxy;
import dev.xkmc.l2core.util.TeleportTool;
import dev.xkmc.l2damagetracker.contents.curios.TotemUseToClient;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import dev.xkmc.l2serial.network.SimplePacketBase;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EternalTotem
extends Item
implements ILCTotem {
    public EternalTotem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean allow(LivingEntity self, DamageSource pDamageSource) {
        Player player;
        return self instanceof Player && !(player = (Player)self).getCooldowns().isOnCooldown((Item)this);
    }

    @Override
    public void trigger(LivingEntity self, ItemStack holded, Consumer<ItemStack> second) {
        L2DamageTracker.PACKET_HANDLER.toTrackingPlayers((SimplePacketBase)TotemUseToClient.of((Entity)self, (ItemStack)holded), (Entity)self);
        self.removeAllEffects();
        self.setHealth(self.getMaxHealth());
        self.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
        self.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
        self.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
        if (self instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)self;
            Level level = self.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                player.getCooldowns().addCooldown((Item)this, ((Integer)LCConfig.SERVER.eternalTotemCoolDown.get()).intValue());
                if (((Boolean)LCConfig.SERVER.eternalTotemGiveWarpStone.get()).booleanValue()) {
                    ItemStack stone = LCItems.FRAGILE_WARP_STONE.asStack();
                    WarpStone.set(stone, self.level(), (Entity)self);
                    player.getInventory().add(stone);
                }
                TeleportTool.teleportHome((ServerLevel)level2, (ServerPlayer)player);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        LocalPlayer player;
        int time = (Integer)LCConfig.SERVER.eternalTotemCoolDown.get() / 20;
        MutableComponent cd = Component.literal((String)("" + time));
        if (level.registries() != null && (player = Proxy.getClientPlayer()) != null && player.getCooldowns().isOnCooldown((Item)this)) {
            time = (int)(player.getCooldowns().getCooldownPercent((Item)this, 0.0f) * (float)time);
            cd = Component.literal((String)("" + time)).withStyle(ChatFormatting.RED);
        }
        list.add((Component)LCLang.IDS.TOTEM_ETERNAL.get(cd).withStyle(ChatFormatting.GRAY));
    }
}

