/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.equipments;

import dev.xkmc.l2complements.init.L2Complements;
import dev.xkmc.l2complements.init.data.LCLang;
import dev.xkmc.l2complements.init.materials.LCMats;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2core.base.effects.EffectUtil;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraArmorConfig;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForgeMod;

public class PoseiditeArmor
extends ExtraArmorConfig {
    private static final Function<ArmorItem.Type, ItemAttributeModifiers> ATTRS = Util.memoize(PoseiditeArmor::modifyDynamicAttributes);
    private static final Function<ArmorItem.Type, ItemAttributeModifiers> ORIGINAL = Util.memoize(PoseiditeArmor::originalAttributes);

    private static ItemAttributeModifiers modifyDynamicAttributes(ArmorItem.Type type) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        LCMats.POSEIDITE.defaultAttributes(builder, type);
        double factor = type.getSlot() == EquipmentSlot.CHEST || type.getSlot() == EquipmentSlot.LEGS ? 1.5 : 1.0;
        EquipmentSlotGroup group = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        builder.add(Attributes.ARMOR, new AttributeModifier(L2Complements.loc("poseidite_armor." + type.getName()), 4.0 * factor, AttributeModifier.Operation.ADD_VALUE), group);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(L2Complements.loc("poseidite_toughness." + type.getName()), 2.0 * factor, AttributeModifier.Operation.ADD_VALUE), group);
        builder.add(Attributes.MOVEMENT_SPEED, new AttributeModifier(L2Complements.loc("poseidite_walk." + type.getName()), 0.1 * factor, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), group);
        return builder.build();
    }

    private static ItemAttributeModifiers originalAttributes(ArmorItem.Type type) {
        return (ItemAttributeModifiers)LCMats.POSEIDITE.getArmor(type.getSlot()).getDefaultInstance().get(DataComponents.ATTRIBUTE_MODIFIERS);
    }

    public void configureAttributes(ItemAttributeModifiers.Builder builder, EquipmentSlot slot) {
        double factor = slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS ? 1.5 : 1.0;
        EquipmentSlotGroup group = EquipmentSlotGroup.bySlot((EquipmentSlot)slot);
        builder.add(NeoForgeMod.SWIM_SPEED, new AttributeModifier(L2Complements.loc("poseidite_swim" + slot.getName()), 0.1 * factor, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), group);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int index, boolean selected) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)entity;
        EquipmentSlot slot = ((ArmorItem)stack.getItem()).getEquipmentSlot();
        if (le.getItemBySlot(slot) != stack) {
            return;
        }
        if (le.isInWaterRainOrBubble()) {
            if (!stack.has((DataComponentType)LCItems.IN_WATER.get())) {
                stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ATTRS.apply(((ArmorItem)stack.getItem()).getType()));
            }
            stack.set((DataComponentType)LCItems.IN_WATER.get(), (Object)Unit.INSTANCE);
            if (slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST) {
                EffectUtil.refreshEffect((LivingEntity)le, (MobEffectInstance)new MobEffectInstance(MobEffects.CONDUIT_POWER, 200), (Entity)le);
            }
            if (slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET) {
                EffectUtil.refreshEffect((LivingEntity)le, (MobEffectInstance)new MobEffectInstance(MobEffects.DOLPHINS_GRACE, 200), (Entity)le);
            }
        } else {
            if (stack.has((DataComponentType)LCItems.IN_WATER.get())) {
                stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ORIGINAL.apply(((ArmorItem)stack.getItem()).getType()));
            }
            stack.remove(LCItems.IN_WATER);
        }
    }

    public void addTooltip(ItemStack stack, List<Component> list) {
        list.add((Component)LCLang.IDS.POSEIDITE_ARMOR.get(new Object[0]).withStyle(ChatFormatting.GRAY));
        super.addTooltip(stack, list);
    }
}

