/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.create;

import dev.xkmc.l2complements.content.item.create.ShadowSteelItem;
import dev.xkmc.l2complements.init.data.LCDamageTypes;
import java.util.function.Supplier;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VoidEyeItem
extends ShadowSteelItem {
    public VoidEyeItem(Item.Properties properties, Supplier<MutableComponent> sup) {
        super(properties, sup);
    }

    @Override
    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        super.onEntityItemUpdate(stack, entity);
        if (entity.getDeltaMovement().y() < 0.05) {
            entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, 0.005, 0.0));
        }
        return false;
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        LivingEntity le;
        if (!pLevel.isClientSide() && pEntity instanceof LivingEntity && (le = (LivingEntity)pEntity).position().y() < (double)pLevel.getMinBuildHeight()) {
            pStack.setCount(0);
            le.hurt(new DamageSource(LCDamageTypes.forKey(pLevel, LCDamageTypes.VOID_EYE)), le.getMaxHealth());
        }
    }
}

