/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.create;

import dev.xkmc.l2complements.content.item.misc.TooltipItem;
import dev.xkmc.l2complements.init.data.LCLang;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class NoGravMagicalDohickyItem
extends TooltipItem {
    public NoGravMagicalDohickyItem(Item.Properties properties, Supplier<MutableComponent> sup) {
        super(properties, sup);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Level world = entity.level();
        Vec3 pos = entity.position();
        CompoundTag persistentData = entity.getPersistentData();
        if (world.isClientSide) {
            if (world.random.nextFloat() < this.getIdleParticleChance(entity)) {
                Vec3 ppos = NoGravMagicalDohickyItem.offsetRandomly(pos, world.random, 0.5f);
                world.addParticle((ParticleOptions)ParticleTypes.END_ROD, ppos.x, pos.y, ppos.z, 0.0, (double)-0.1f, 0.0);
            }
            if (entity.isSilent() && !persistentData.getBoolean("PlayEffects")) {
                Vec3 basemotion = new Vec3(0.0, 1.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.FLASH, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
                for (int i = 0; i < 20; ++i) {
                    Vec3 motion = NoGravMagicalDohickyItem.offsetRandomly(basemotion, world.random, 1.0f);
                    world.addParticle((ParticleOptions)ParticleTypes.WITCH, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
                    world.addParticle((ParticleOptions)ParticleTypes.END_ROD, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
                }
                persistentData.putBoolean("PlayEffects", true);
            }
            return false;
        }
        entity.setGlowingTag(true);
        entity.setNoGravity(true);
        if (!persistentData.contains("JustCreated")) {
            return false;
        }
        this.onCreated(entity, persistentData);
        return false;
    }

    protected float getIdleParticleChance(ItemEntity entity) {
        return (float)Mth.clamp((int)(entity.getItem().getCount() - 10), (int)5, (int)100) / 64.0f;
    }

    protected void onCreated(ItemEntity entity, CompoundTag persistentData) {
        entity.lifespan = 6000;
        persistentData.remove("JustCreated");
        entity.setSilent(true);
    }

    public static Vec3 offsetRandomly(Vec3 vec, RandomSource r, float radius) {
        return new Vec3(vec.x + (double)((r.nextFloat() - 0.5f) * 2.0f * radius), vec.y + (double)((r.nextFloat() - 0.5f) * 2.0f * radius), vec.z + (double)((r.nextFloat() - 0.5f) * 2.0f * radius));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, level, list, flag);
        list.add((Component)LCLang.IDS.FLOAT.get(new Object[0]).withStyle(ChatFormatting.GRAY));
    }
}

