/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.base;

import com.tterrag.registrate.util.entry.MenuEntry;
import dev.xkmc.l2complements.init.data.LCLang;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ContainerBook
extends Item
implements MenuProvider {
    private final Supplier<MenuEntry<?>> cont;

    public ContainerBook(Item.Properties props, Supplier<MenuEntry<?>> cont) {
        super(props);
        this.cont = cont;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide()) {
            player.openMenu((MenuProvider)this);
        } else {
            player.playSound(SoundEvents.BOOK_PAGE_TURN, 1.0f, 1.0f);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public Component getDisplayName() {
        return LCLang.translate(ContainerBook.getLangKey((MenuType)this.cont.get().get()), new Object[0]);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int wid, Inventory plInv, Player pl) {
        return this.cont.get().create(wid, plInv);
    }

    public static String getLangKey(MenuType<?> menu) {
        ResourceLocation rl = Objects.requireNonNull(BuiltInRegistries.MENU.getKey(menu));
        return "container." + rl.getNamespace() + "." + rl.getPath();
    }

    public static interface IFac {
        public AbstractContainerMenu create(int var1, Inventory var2, Player var3);
    }
}

