/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xkmc.l2complements.content.entity.ISizedItemEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpecialSpriteRenderer<T extends Entity & ISizedItemEntity>
extends EntityRenderer<T> {
    private final ItemRenderer itemRenderer;
    private final boolean fullBright;

    public SpecialSpriteRenderer(EntityRendererProvider.Context manager, ItemRenderer itemRenderer, boolean bright) {
        super(manager);
        this.itemRenderer = itemRenderer;
        this.fullBright = bright;
    }

    protected int getBlockLightLevel(T entity, BlockPos pos) {
        return this.fullBright ? 15 : super.getBlockLightLevel(entity, pos);
    }

    public void render(T entity, float yRot, float partial, PoseStack matrix, MultiBufferSource buffer, int light) {
        if (((Entity)entity).tickCount >= 2 || !(this.entityRenderDispatcher.camera.getEntity().distanceToSqr(entity) < 12.25)) {
            matrix.pushPose();
            float size = ((ISizedItemEntity)entity).getSize();
            matrix.scale(size, size, size);
            matrix.mulPose(this.entityRenderDispatcher.cameraOrientation());
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
            this.itemRenderer.renderStatic(((ItemSupplier)entity).getItem(), ItemDisplayContext.GROUND, light, OverlayTexture.NO_OVERLAY, matrix, buffer, entity.level(), 0);
            matrix.popPose();
            super.render(entity, yRot, partial, matrix, buffer, light);
        }
    }

    public ResourceLocation getTextureLocation(Entity p_110775_1_) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

