/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.enchantment.digging;

import dev.xkmc.l2complements.content.enchantment.digging.BlockBreaker;
import dev.xkmc.l2complements.content.enchantment.digging.DelayedBlockBreaker;
import dev.xkmc.l2complements.content.enchantment.digging.DiggerContext;
import dev.xkmc.l2complements.content.enchantment.digging.DiggerHelper;
import dev.xkmc.l2complements.init.L2Complements;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.LCLang;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2core.events.SchedulerHandler;
import dev.xkmc.l2core.init.reg.ench.CustomDescEnchantment;
import dev.xkmc.l2core.init.reg.ench.EnchColor;
import dev.xkmc.l2core.init.reg.ench.LegacyEnchantment;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RangeDiggingEnchantment
extends LegacyEnchantment
implements CustomDescEnchantment {
    private static final Set<UUID> BREAKER = new HashSet<UUID>();
    private final BlockBreaker breaker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Player player, Runnable run) {
        Set<UUID> set = BREAKER;
        synchronized (set) {
            if (BREAKER.contains(player.getUUID())) {
                return;
            }
            BREAKER.add(player.getUUID());
            try {
                run.run();
            }
            catch (Exception e) {
                L2Complements.LOGGER.throwing(org.apache.logging.log4j.Level.ERROR, (Throwable)e);
            }
            BREAKER.remove(player.getUUID());
        }
    }

    public static void breakBlockWrapped(ServerPlayer player, BlockPos pos) {
        player.gameMode.destroyBlock(pos);
    }

    public static boolean isSuppressed(UUID uuid) {
        return BREAKER.contains(uuid);
    }

    private static Direction getFace(Player player) {
        Level level = player.level();
        Vec3 base = player.getEyePosition(0.0f);
        Vec3 look = player.getLookAngle();
        double reach = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vec3 target = base.add(look.x * reach, look.y * reach, look.z * reach);
        BlockHitResult trace = level.clip(new ClipContext(base, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        return trace.getDirection();
    }

    private static double hardnessFactor() {
        return (Double)LCConfig.SERVER.chainDiggingHardnessRange.get();
    }

    private static boolean canBreak(BlockPos i, Level level, Player player, double hardness) {
        BlockState state = level.getBlockState(i);
        if (state.isAir()) {
            return false;
        }
        if (!player.hasCorrectToolForDrops(state, level, i)) {
            return false;
        }
        float speed = state.getDestroySpeed((BlockGetter)player.level(), i);
        if (speed < 0.0f) {
            return false;
        }
        return hardness < 0.0 || (double)speed <= hardness;
    }

    public RangeDiggingEnchantment(BlockBreaker breaker) {
        this.breaker = breaker;
    }

    public List<BlockPos> getTargets(Player player, BlockPos pos, ItemStack stack, int lv) {
        Level level = player.level();
        BlockState state = level.getBlockState(pos);
        double hardness = this.breaker.ignoreHardness() ? -1.0 : (double)state.getDestroySpeed((BlockGetter)level, pos) * RangeDiggingEnchantment.hardnessFactor();
        return this.breaker.getInstance(new DiggerContext(player, RangeDiggingEnchantment.getFace(player), stack, lv, pos, state)).find(level, pos, i -> !pos.equals(i) && RangeDiggingEnchantment.canBreak(i, level, player, hardness));
    }

    public void onBlockBreak(ServerPlayer player, BlockPos pos, ItemStack stack, int lv) {
        List<BlockPos> blocks = this.getTargets((Player)player, pos, stack, lv);
        RangeDiggingEnchantment.execute((Player)player, () -> {
            int max = (Integer)LCConfig.SERVER.chainDiggingDelayThreshold.get();
            if (blocks.size() <= max) {
                for (BlockPos i : blocks) {
                    RangeDiggingEnchantment.breakBlockWrapped(player, i);
                }
            } else {
                if (((Boolean)LCConfig.SERVER.delayDiggingRequireEnder.get()).booleanValue() && stack.getEnchantmentLevel(LCEnchantments.ENDER_TRANSPORT.holder()) <= 0) {
                    player.sendSystemMessage((Component)LCLang.IDS.DELAY_WARNING.get(Enchantment.getFullname((Holder)LCEnchantments.ENDER_TRANSPORT.holder(), (int)1), max).withStyle(ChatFormatting.RED), true);
                    return;
                }
                SchedulerHandler.schedulePersistent(new DelayedBlockBreaker(player, blocks)::tick);
            }
        });
    }

    public Component title(ItemStack stack, Component comp, boolean alt, boolean book, EnchColor color) {
        DiggerHelper.Digger ans = DiggerHelper.getDigger(stack);
        if (ans != null) {
            if (ans.digger() != this) {
                return Component.literal((String)"-> ").withStyle(ChatFormatting.DARK_GRAY).append((Component)comp.copy().withStyle(color.base()));
            }
            return Component.literal((String)"-> ").withStyle(ChatFormatting.GRAY).append((Component)comp.copy().withStyle(new ChatFormatting[]{color.base(), ChatFormatting.ITALIC}));
        }
        return comp.copy().withStyle(color.base());
    }

    public List<Component> descFull(ItemStack stack, int lv, String key, boolean alt, boolean book, EnchColor color) {
        DiggerHelper.Digger ans = DiggerHelper.getDigger(stack);
        if (ans != null && ans.digger() != this) {
            return List.of();
        }
        return this.breaker.descFull(lv, key, alt, book);
    }
}

