/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.enchantment.digging;

import com.google.common.collect.Lists;
import dev.xkmc.l2complements.content.enchantment.digging.RangeDiggingEnchantment;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2core.init.L2LibReg;
import dev.xkmc.l2core.init.reg.ench.EnchHolder;
import dev.xkmc.l2core.init.reg.ench.LegacyEnchantment;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class DiggerHelper {
    private static final String KEY = "l2complements:selected_digger";

    @Nullable
    private static RangeDiggingEnchantment of(Enchantment ench) {
        List list = ench.getEffects((DataComponentType)L2LibReg.LEGACY.get());
        for (LegacyEnchantment e : list) {
            if (!(e instanceof RangeDiggingEnchantment)) continue;
            RangeDiggingEnchantment digger = (RangeDiggingEnchantment)e;
            return digger;
        }
        return null;
    }

    @Nullable
    public static Digger getDigger(ItemStack stack) {
        if (stack.isEmpty() || !stack.isEnchanted()) {
            return null;
        }
        HolderLookup.RegistryLookup reg = CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT);
        if (reg == null) {
            return null;
        }
        Optional<Holder.Reference> ench = Optional.ofNullable((String)stack.get(LCItems.DIGGER_SEL)).map(ResourceLocation::tryParse).map(e -> reg.getOrThrow(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)e)));
        Optional<List> list = ench.map(e -> ((Enchantment)e.value()).getEffects((DataComponentType)L2LibReg.LEGACY.get()));
        if (ench.isEmpty() || list.get().isEmpty()) {
            return null;
        }
        LegacyEnchantment legacy = (LegacyEnchantment)list.get().getFirst();
        if (!(legacy instanceof RangeDiggingEnchantment)) {
            return null;
        }
        RangeDiggingEnchantment digger = (RangeDiggingEnchantment)legacy;
        int lv = ((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).getLevel((Holder)ench.get());
        if (lv <= 0) {
            return null;
        }
        return new Digger((Holder<Enchantment>)((Holder)ench.get()), digger, lv);
    }

    public static void rotateDigger(ItemStack stack, boolean reverse) {
        List list = LegacyEnchantment.findAll((ItemStack)stack, RangeDiggingEnchantment.class, (boolean)true);
        if (reverse) {
            list = Lists.reverse((List)list);
        }
        Digger current = DiggerHelper.getDigger(stack);
        for (EnchHolder ent : list) {
            if (current == null) {
                LCItems.DIGGER_SEL.set(stack, (Object)((ResourceKey)ent.holder().unwrapKey().orElseThrow()).location().toString());
                return;
            }
            if (ent.holder().value() != current.ench().value()) continue;
            current = null;
        }
        stack.remove((DataComponentType)LCItems.DIGGER_SEL.get());
    }

    public record Digger(Holder<Enchantment> ench, RangeDiggingEnchantment digger, int level) {
    }
}

