/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.effect;

import dev.xkmc.l2complements.content.effect.BaseEffect;
import dev.xkmc.l2complements.events.MagicEventHandler;
import dev.xkmc.l2complements.init.L2Complements;
import dev.xkmc.l2core.base.effects.api.DelayedEntityRender;
import dev.xkmc.l2core.base.effects.api.IconOverlayEffect;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class CleanseEffect
extends BaseEffect
implements IconOverlayEffect {
    private static int recursive = 0;

    public static void clearOnEntity(LivingEntity entity) {
        ++recursive;
        ArrayList list = new ArrayList(entity.getActiveEffects());
        for (MobEffectInstance ins : list) {
            if (MagicEventHandler.isSkill(ins, entity)) continue;
            if (recursive <= 1) {
                entity.removeEffect(ins.getEffect());
            }
            if (!entity.hasEffect(ins.getEffect())) continue;
            entity.getActiveEffectsMap().remove(ins.getEffect());
        }
        --recursive;
    }

    public CleanseEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public DelayedEntityRender getIcon(LivingEntity entity, int lv) {
        return DelayedEntityRender.icon((LivingEntity)entity, (ResourceLocation)L2Complements.loc("textures/effect_overlay/cleanse.png"));
    }

    public void onEffectAdded(LivingEntity livingEntity, int amplifier) {
        CleanseEffect.clearOnEntity(livingEntity);
    }

    public boolean shouldApplyEffectTickThisTick(int tick, int amp) {
        return tick % 10 == 0;
    }

    public boolean applyEffectTick(LivingEntity pLivingEntity, int pAmplifier) {
        CleanseEffect.clearOnEntity(pLivingEntity);
        return true;
    }
}

