/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.effect;

import dev.xkmc.l2complements.content.effect.ExponentEffect;
import dev.xkmc.l2complements.content.effect.StackingEffect;
import dev.xkmc.l2complements.init.L2Complements;
import dev.xkmc.l2complements.init.data.LCDamageTypes;
import dev.xkmc.l2core.base.effects.api.DelayedEntityRender;
import dev.xkmc.l2core.base.effects.api.IconOverlayEffect;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class BleedEffect
extends ExponentEffect
implements IconOverlayEffect,
StackingEffect<BleedEffect> {
    private static final ResourceLocation ID_SLOW = L2Complements.loc("bleed_slow");
    private static final ResourceLocation ID_ATK = L2Complements.loc("bleed_atk");

    public BleedEffect(MobEffectCategory category, int color) {
        super(category, color);
        this.addAttributeModifier((Holder<Attribute>)Attributes.MOVEMENT_SPEED, ID_SLOW, -0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        this.addAttributeModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, ID_ATK, -0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public boolean applyEffectTick(LivingEntity target, int level) {
        DamageSource source = new DamageSource(LCDamageTypes.forKey(target.level(), LCDamageTypes.BLEED));
        target.hurt(source, (float)(6 * (level + 1)));
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 60 == 0;
    }

    public DelayedEntityRender getIcon(LivingEntity entity, int lv) {
        return DelayedEntityRender.icon((LivingEntity)entity, (ResourceLocation)L2Complements.loc("textures/effect_overlay/bleed_" + Mth.clamp((int)lv, (int)0, (int)8) + ".png"));
    }
}

