/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.compat;

import dev.xkmc.l2complements.content.item.curios.EffectValidItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CurioCompat {
    public static List<ItemStack> getAllSlots(LivingEntity le) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (EquipmentSlot e : EquipmentSlot.values()) {
            list.add(le.getItemBySlot(e));
        }
        if (ModList.get().isLoaded("curios")) {
            CurioCompat.fillSlots(le, list);
        }
        return list;
    }

    private static void fillSlots(LivingEntity le, List<ItemStack> list) {
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)le);
        if (opt.isPresent()) {
            ICuriosItemHandler curio = (ICuriosItemHandler)opt.get();
            for (ICurioStacksHandler handler : curio.getCurios().values()) {
                IDynamicStackHandler stacks = handler.getStacks();
                int n = stacks.getSlots();
                for (int i = 0; i < n; ++i) {
                    ItemStack stack = stacks.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    list.add(stack);
                }
            }
        }
    }

    public static boolean testEffect(MobEffectInstance ins, LivingEntity entity) {
        if (ModList.get().isLoaded("curios")) {
            return CurioCompat.testEffectImpl(ins, entity);
        }
        return false;
    }

    private static boolean testEffectImpl(MobEffectInstance ins, LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(cap -> cap.findFirstCurio(e -> {
            EffectValidItem item;
            Item patt0$temp = e.getItem();
            return patt0$temp instanceof EffectValidItem && (item = (EffectValidItem)patt0$temp).isEffectValid(ins, (ItemStack)e, entity);
        })).isPresent();
    }
}

