/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.util;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class MoveAnalysis {
    private final Entity entity;
    private int lastTick;
    private Vec3 lastPosition;
    private double deltaX;
    private double deltaY;
    private double deltaZ;

    public MoveAnalysis(Entity entity) {
        this.entity = entity;
        this.lastPosition = entity.position();
    }

    public void update() {
        if (this.entity.tickCount == this.lastTick) {
            return;
        }
        Vec3 prevPos = this.lastPosition;
        double prevPosX = prevPos.x;
        double prevPosY = prevPos.y;
        double prevPosZ = prevPos.z;
        Vec3 pos = this.entity.position();
        double posX = pos.x;
        double posY = pos.y;
        double posZ = pos.z;
        this.deltaX = posX - prevPosX;
        this.deltaY = posY - prevPosY;
        this.deltaZ = posZ - prevPosZ;
        this.lastPosition = this.entity.position();
        this.lastTick = this.entity.tickCount;
    }

    public boolean isMovingHorizontally() {
        return this.deltaX != 0.0 || this.deltaZ != 0.0;
    }

    public boolean isMovingVertically() {
        return this.deltaY != 0.0;
    }

    public boolean isMoving() {
        return this.isMovingHorizontally() || this.isMovingVertically();
    }
}

